/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="endpoint-list", description="Lists all Camel endpoints available in CamelContexts.")
public class EndpointList
extends OsgiCommandSupport {
    protected static final String HEADER_FORMAT = "%-20s %-20s %-20s";
    protected static final String OUTPUT_FORMAT = "[%-18s] [%-18s] [%-18s]";
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        System.out.println(String.format(HEADER_FORMAT, "camel-id", "uri", "Status"));
        List<CamelContext> camelContexts = this.camelController.getCamelContexts();
        for (CamelContext camelContext : camelContexts) {
            List endpoints = (List)camelContext.getEndpoints();
            for (Endpoint endpoint : endpoints) {
                System.out.println(String.format(OUTPUT_FORMAT, camelContext.getName(), endpoint.getEndpointUri(), this.getState(endpoint)));
            }
        }
        return null;
    }

    protected String getState(Endpoint endpoint) {
        if (endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }
}

