/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class IgnoreNullMapTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (typeToken.getRawType() != Map.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
        TypeAdapter keyAdapter = gson.getAdapter(TypeToken.get((Type)keyType));
        TypeAdapter valueAdapter = gson.getAdapter(TypeToken.get((Type)valueType));
        return this.newMapAdapter(keyAdapter, valueAdapter);
    }

    protected <K, V> TypeAdapter<Map<K, V>> newMapAdapter(final TypeAdapter<K> keyAdapter, final TypeAdapter<V> valueAdapter) {
        return new TypeAdapter<Map<K, V>>(){

            public void write(JsonWriter out, Map<K, V> value) throws IOException {
                out.beginObject();
                for (Map.Entry element : value.entrySet()) {
                    out.name(String.valueOf(element.getKey()));
                    valueAdapter.write(out, element.getValue());
                }
                out.endObject();
            }

            public Map<K, V> read(JsonReader in) throws IOException {
                LinkedHashMap result = Maps.newLinkedHashMap();
                in.beginObject();
                while (in.hasNext()) {
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    Object name = keyAdapter.read(in);
                    Object value = valueAdapter.read(in);
                    if (value == null) continue;
                    result.put(name, value);
                }
                in.endObject();
                return result;
            }
        }.nullSafe();
    }
}

