/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.predicates.Validator;
import org.jclouds.rest.annotations.ParamValidators;

public class InputParamValidator {
    private final Injector injector;

    @Inject
    public InputParamValidator(Injector injector) {
        this.injector = injector;
    }

    public InputParamValidator() {
        this.injector = null;
    }

    public void validateMethodParametersOrThrow(Method method, Object ... args) {
        try {
            this.performMethodValidation(method, args);
            this.performParameterValidation(method.getParameterAnnotations(), args);
        }
        catch (IllegalArgumentException e) {
            String argsString = Iterables.toString(Arrays.asList(args));
            throw new IllegalArgumentException(String.format("Validation on '%s#%s' didn't pass for arguments: %s. %n Reason: %s.", method.getDeclaringClass().getName(), method.getName(), argsString, e.getMessage()));
        }
    }

    private void performMethodValidation(Method method, Object ... args) {
        ParamValidators paramValidatorsAnnotation = ((Method)Preconditions.checkNotNull((Object)method)).getAnnotation(ParamValidators.class);
        if (paramValidatorsAnnotation == null) {
            return;
        }
        List<Validator<?>> methodValidators = this.getValidatorsFromAnnotation(paramValidatorsAnnotation);
        this.runPredicatesAgainstArgs(methodValidators, args);
    }

    private void performParameterValidation(Annotation[][] annotations, Object ... args) {
        for (int currentParameterIndex = 0; currentParameterIndex < annotations.length; ++currentParameterIndex) {
            ParamValidators annotation = this.findParamValidatorsAnnotationOrReturnNull(annotations[currentParameterIndex]);
            if (annotation == null) continue;
            List<Validator<?>> parameterValidators = this.getValidatorsFromAnnotation(annotation);
            this.runPredicatesAgainstArgs(parameterValidators, args[currentParameterIndex]);
        }
    }

    private List<Validator<?>> getValidatorsFromAnnotation(ParamValidators paramValidatorsAnnotation) {
        ArrayList validators = Lists.newArrayList();
        for (Class<? extends Validator<?>> validator : paramValidatorsAnnotation.value()) {
            validators.add(Preconditions.checkNotNull((Object)this.injector.getInstance(validator)));
        }
        return validators;
    }

    private void runPredicatesAgainstArgs(List<Validator<?>> predicates, Object ... args) {
        for (Validator<?> validator : predicates) {
            Iterables.all(Arrays.asList(args), validator);
        }
    }

    private ParamValidators findParamValidatorsAnnotationOrReturnNull(Annotation[] parameterAnnotations) {
        for (Annotation annotation : parameterAnnotations) {
            if (!(annotation instanceof ParamValidators)) continue;
            return (ParamValidators)annotation;
        }
        return null;
    }
}

