/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ListableMap;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;

public abstract class BaseBlobMap<V>
implements ListableMap<String, V> {
    protected final BlobStore blobstore;
    protected final String containerName;
    protected final Function<String, String> prefixer;
    protected final Function<String, String> pathStripper;
    protected final ListContainerOptions options;
    protected final GetBlobsInListStrategy getAllBlobs;
    protected final ContainsValueInListStrategy containsValueStrategy;
    protected final ListContainerAndRecurseThroughFolders listStrategy;
    protected final PutBlobsStrategy putBlobsStrategy;

    @Inject
    public BaseBlobMap(BlobStore blobstore, GetBlobsInListStrategy getAllBlobs, ContainsValueInListStrategy containsValueStrategy, PutBlobsStrategy putBlobsStrategy, ListContainerAndRecurseThroughFolders listStrategy, String containerName, ListContainerOptions options) {
        this.blobstore = (BlobStore)Preconditions.checkNotNull((Object)blobstore, (Object)"blobstore");
        this.containerName = (String)Preconditions.checkNotNull((Object)containerName, (Object)"container");
        Preconditions.checkArgument((containerName.indexOf(47) == -1 ? 1 : 0) != 0, (Object)"please specify directory path using the option: inDirectory, not encoded in the container name");
        this.options = Preconditions.checkNotNull((Object)options, (Object)"options") instanceof ListContainerOptions.ImmutableListContainerOptions ? options : new ListContainerOptions.ImmutableListContainerOptions(options);
        String dir = options.getDir();
        if (dir == null) {
            this.prefixer = Functions.identity();
            this.pathStripper = this.prefixer;
        } else {
            this.prefixer = new PrefixKey(dir, "/");
            this.pathStripper = new StripPath(dir, "/");
        }
        this.getAllBlobs = (GetBlobsInListStrategy)Preconditions.checkNotNull((Object)getAllBlobs, (Object)"getAllBlobs");
        this.listStrategy = (ListContainerAndRecurseThroughFolders)Preconditions.checkNotNull((Object)listStrategy, (Object)"listStrategy");
        this.containsValueStrategy = (ContainsValueInListStrategy)Preconditions.checkNotNull((Object)containsValueStrategy, (Object)"containsValueStrategy");
        this.putBlobsStrategy = (PutBlobsStrategy)Preconditions.checkNotNull((Object)putBlobsStrategy, (Object)"putBlobsStrategy");
        Preconditions.checkArgument((!containerName.equals("") ? 1 : 0) != 0, (Object)"container name must not be a blank string!");
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.list(), (Function)new Function<BlobMetadata, Map.Entry<String, V>>(){

            public Map.Entry<String, V> apply(BlobMetadata from) {
                return new Entry((String)BaseBlobMap.this.pathStripper.apply((Object)from.getName()));
            }
        }));
    }

    @Override
    public int size() {
        return (int)this.blobstore.countBlobs(this.containerName, this.options);
    }

    protected Iterable<Blob> getAllBlobs() {
        Iterable<Blob> returnVal = this.getAllBlobs.execute(this.containerName, this.options);
        if (this.options != null) {
            for (Blob from : returnVal) {
                this.stripPrefix(from);
            }
        }
        return returnVal;
    }

    protected Blob stripPrefix(Blob from) {
        from.getMetadata().setName((String)this.pathStripper.apply((Object)from.getMetadata().getName()));
        return from;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValueStrategy.execute(this.containerName, value, this.options);
    }

    @Override
    public void clear() {
        this.blobstore.clearContainer(this.containerName, this.options);
    }

    @Override
    public Set<String> keySet() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.list(), (Function)new Function<BlobMetadata, String>(){

            public String apply(BlobMetadata from) {
                return from.getName();
            }
        }));
    }

    @Override
    public boolean containsKey(Object key) {
        String realKey = (String)this.prefixer.apply((Object)Preconditions.checkNotNull((Object)key, (Object)"key").toString());
        return this.blobstore.blobExists(this.containerName, realKey);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterable<? extends BlobMetadata> list() {
        return Iterables.transform(this.listStrategy.execute(this.containerName, this.options), (Function)new Function<BlobMetadata, BlobMetadata>(){

            public BlobMetadata apply(BlobMetadata from) {
                MutableBlobMetadataImpl md = new MutableBlobMetadataImpl(from);
                if (BaseBlobMap.this.options.getDir() != null) {
                    md.setName((String)BaseBlobMap.this.pathStripper.apply((Object)from.getName()));
                }
                return md;
            }
        });
    }

    public String toString() {
        return "[containerName=" + this.containerName + ", options=" + this.options + "]";
    }

    public class Entry
    implements Map.Entry<String, V> {
        private final String key;

        Entry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return BaseBlobMap.this.get(BaseBlobMap.this.prefixer.apply((Object)this.key));
        }

        @Override
        public V setValue(V value) {
            return BaseBlobMap.this.put(BaseBlobMap.this.prefixer.apply((Object)this.key), value);
        }
    }

    static class PrefixKey
    implements Function<String, String> {
        private final String prefix;
        private final String delimiter;

        PrefixKey(String prefix, String delimiter) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            this.delimiter = (String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter");
        }

        public String apply(String from) {
            return this.prefix + this.delimiter + from;
        }
    }

    static class StripPath
    implements Function<String, String> {
        private final String prefix;
        private final String delimiter;

        StripPath(String prefix, String delimiter) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            this.delimiter = (String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter");
        }

        public String apply(String from) {
            return from.replaceFirst(this.prefix + this.delimiter, "");
        }
    }
}

