/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearContainerStrategy;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllKeysInList
implements ClearListStrategy,
ClearContainerStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler retryHandler;
    private final ExecutorService userExecutor;
    protected final AsyncBlobStore connection;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime = Long.MAX_VALUE;

    @Inject
    DeleteAllKeysInList(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore connection, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.connection = connection;
        this.retryHandler = retryHandler;
    }

    @Override
    public void execute(String containerName) {
        this.execute(containerName, ListContainerOptions.Builder.recursive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String containerName, ListContainerOptions options) {
        String message = options.getDir() != null ? String.format("clearing path %s/%s", containerName, options.getDir()) : String.format("clearing container %s", containerName);
        if ((options = options.clone()).isRecursive()) {
            message = message + " recursively";
        }
        this.logger.debug(message, new Object[0]);
        Map exceptions = Maps.newHashMap();
        int maxErrors = 3;
        int numErrors = 0;
        while (numErrors < maxErrors) {
            PageSet listing;
            ListenableFuture<PageSet<? extends StorageMetadata>> listFuture = this.connection.list(containerName, options);
            try {
                listing = (PageSet)listFuture.get(this.maxTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException ee) {
                if (++numErrors == maxErrors) {
                    throw Throwables.propagate((Throwable)ee.getCause());
                }
                this.retryHandler.imposeBackoffExponentialDelay(numErrors, message);
                continue;
            }
            catch (TimeoutException te) {
                if (++numErrors == maxErrors) {
                    throw Throwables.propagate((Throwable)te);
                }
                this.retryHandler.imposeBackoffExponentialDelay(numErrors, message);
                continue;
            }
            finally {
                listFuture.cancel(true);
                continue;
            }
            if (options.isRecursive()) {
                for (StorageMetadata md : listing) {
                    String fullPath = this.parentIsFolder(options, md) ? options.getDir() + "/" + md.getName() : md.getName();
                    switch (md.getType()) {
                        case BLOB: {
                            break;
                        }
                        case FOLDER: 
                        case RELATIVE_PATH: {
                            if (!options.isRecursive() || fullPath.equals(options.getDir())) break;
                            this.execute(containerName, options.clone().inDirectory(fullPath));
                            break;
                        }
                        case CONTAINER: {
                            throw new IllegalArgumentException("Container type not supported");
                        }
                    }
                }
            }
            HashMap responses = Maps.newHashMap();
            for (StorageMetadata md : listing) {
                String fullPath = this.parentIsFolder(options, md) ? options.getDir() + "/" + md.getName() : md.getName();
                switch (md.getType()) {
                    case BLOB: {
                        responses.put(md, this.connection.removeBlob(containerName, fullPath));
                        break;
                    }
                    case FOLDER: {
                        if (!options.isRecursive()) break;
                        responses.put(md, this.connection.deleteDirectory(containerName, fullPath));
                        break;
                    }
                    case RELATIVE_PATH: {
                        if (!options.isRecursive()) break;
                        responses.put(md, this.connection.deleteDirectory(containerName, md.getName()));
                        break;
                    }
                    case CONTAINER: {
                        throw new IllegalArgumentException("Container type not supported");
                    }
                }
            }
            try {
                exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)message);
            }
            catch (TimeoutException te) {
                if (++numErrors == maxErrors) {
                    throw Throwables.propagate((Throwable)te);
                }
                this.retryHandler.imposeBackoffExponentialDelay(numErrors, message);
            }
            finally {
                for (Future future : responses.values()) {
                    future.cancel(true);
                }
                continue;
            }
            if (!exceptions.isEmpty()) {
                this.retryHandler.imposeBackoffExponentialDelay(++numErrors, message);
                continue;
            }
            String marker = listing.getNextMarker();
            if (marker == null) break;
            this.logger.debug("%s with marker %s", new Object[]{message, marker});
            options = options.afterMarker(marker);
            numErrors = 0;
        }
        if (!exceptions.isEmpty()) {
            throw new BlobRuntimeException(String.format("error %s: %s", message, exceptions));
        }
    }

    private boolean parentIsFolder(ListContainerOptions options, StorageMetadata md) {
        return options.getDir() != null && md.getName().indexOf(47) == -1;
    }
}

