/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.data.LinearInterpolator;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.rrd4j.inspector.Util;

class GraphFrame
extends JFrame {
    private static final Color COLOR = Color.RED;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 240;
    private int deltaWidth = 0;
    private int deltaHeight = 0;
    private Color color = COLOR;
    private GraphPanel graphPanel = new GraphPanel();
    private JComboBox graphCombo = new JComboBox();
    private RrdGraph rrdGraph;
    private String sourcePath;
    private int dsIndex;
    private int arcIndex;

    GraphFrame(String sourcePath, int dsIndex, int arcIndex) {
        this.sourcePath = sourcePath;
        this.dsIndex = dsIndex;
        this.arcIndex = arcIndex;
        this.fillGraphCombo();
        this.constructUI();
        this.pack();
        Util.placeWindow(this);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRrdGraph() {
        System.out.println("Creating graph...");
        try {
            RrdDef rrdDef;
            double[] values;
            long[] timestamps;
            long t2;
            long t1;
            String dsName;
            RrdDb rrdDb = new RrdDb(this.sourcePath, true);
            try {
                Datasource ds = rrdDb.getDatasource(this.dsIndex);
                Archive arc = rrdDb.getArchive(this.arcIndex);
                Robin robin = arc.getRobin(this.dsIndex);
                dsName = ds.getName();
                t1 = arc.getStartTime();
                t2 = arc.getEndTime();
                long step = arc.getArcStep();
                int count = robin.getSize();
                timestamps = new long[count];
                for (int i = 0; i < count; ++i) {
                    timestamps[i] = t1 + (long)i * step;
                }
                values = robin.getValues();
                rrdDef = rrdDb.getRrdDef();
            }
            finally {
                rrdDb.close();
            }
            RrdGraphDef rrdGraphDef = new RrdGraphDef();
            rrdGraphDef.setTimeSpan(t1, t2);
            rrdGraphDef.setImageFormat("png");
            rrdGraphDef.setTitle(rrdDef.getDsDefs()[this.dsIndex].dump() + " " + rrdDef.getArcDefs()[this.arcIndex].dump());
            LinearInterpolator linearInterpolator = new LinearInterpolator(timestamps, values);
            linearInterpolator.setInterpolationMethod(1);
            rrdGraphDef.datasource(dsName, linearInterpolator);
            rrdGraphDef.area(dsName, this.color, dsName + "\\r");
            rrdGraphDef.comment("START: " + new Date(t1 * 1000L) + "\\r");
            rrdGraphDef.comment("END: " + new Date(t2 * 1000L) + "\\r");
            int width = this.graphPanel.getWidth();
            int height = this.graphPanel.getHeight();
            rrdGraphDef.setWidth(width + this.deltaWidth);
            rrdGraphDef.setHeight(height + this.deltaHeight);
            this.rrdGraph = new RrdGraph(rrdGraphDef);
            if (this.deltaWidth == 0 && this.deltaHeight == 0) {
                RrdGraphInfo info = this.rrdGraph.getRrdGraphInfo();
                this.deltaWidth = this.graphPanel.getWidth() - info.getWidth();
                this.deltaHeight = this.graphPanel.getHeight() - info.getHeight();
                if (this.deltaWidth != 0 && this.deltaHeight != 0) {
                    this.createRrdGraph();
                }
            }
        }
        catch (Exception e) {
            Util.error((Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillGraphCombo() {
        try {
            RrdDb rrdDb = new RrdDb(this.sourcePath, true);
            try {
                RrdDef rrdDef = rrdDb.getRrdDef();
                DsDef[] dsDefs = rrdDef.getDsDefs();
                ArcDef[] arcDefs = rrdDef.getArcDefs();
                GraphComboItem[] items = new GraphComboItem[rrdDef.getDsCount() * rrdDef.getArcCount()];
                int selectedItem = -1;
                int k = 0;
                for (int i = 0; i < rrdDef.getDsCount(); ++i) {
                    for (int j = 0; j < rrdDef.getArcCount(); ++j) {
                        String description = dsDefs[i].dump() + " " + arcDefs[j].dump();
                        items[k] = new GraphComboItem(description, i, j);
                        if (i == this.dsIndex && j == this.arcIndex) {
                            selectedItem = k;
                        }
                        ++k;
                    }
                }
                this.graphCombo.setModel(new DefaultComboBoxModel<GraphComboItem>(items));
                this.graphCombo.setSelectedIndex(selectedItem);
            }
            finally {
                rrdDb.close();
            }
        }
        catch (Exception e) {
            Util.error((Component)this, e);
        }
    }

    private void constructUI() {
        this.setTitle(new File(this.sourcePath).getName());
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout(0, 0));
        content.add((Component)this.graphCombo, "North");
        this.graphPanel.setPreferredSize(new Dimension(400, 240));
        content.add((Component)this.graphPanel, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new FlowLayout(0, 0, 0));
        JButton colorButton = new JButton("Change graph color");
        southPanel.add(colorButton);
        colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphFrame.this.changeColor();
            }
        });
        JButton saveButton = new JButton("Save graph");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphFrame.this.saveGraph();
            }
        });
        southPanel.add(Box.createHorizontalStrut(3));
        southPanel.add(saveButton);
        content.add((Component)southPanel, "South");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GraphFrame.this.closeWindow();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GraphFrame.this.createRrdGraph();
                GraphFrame.this.graphPanel.repaint();
            }
        });
        this.graphCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GraphComboItem item = (GraphComboItem)e.getItem();
                    GraphFrame.this.dsIndex = item.getDsIndex();
                    GraphFrame.this.arcIndex = item.getArcIndex();
                    GraphFrame.this.createRrdGraph();
                    GraphFrame.this.graphPanel.repaint();
                }
            }
        });
    }

    private void closeWindow() {
        Util.dismissWindow(this);
    }

    private void changeColor() {
        final JColorChooser picker = new JColorChooser(this.color);
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphFrame.this.color = picker.getColor();
                GraphFrame.this.createRrdGraph();
                GraphFrame.this.repaint();
            }
        };
        JColorChooser.createDialog(this, "Select color", true, picker, okListener, null).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph() {
        JFileChooser chooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".png");
            }

            public String getDescription() {
                return "PNG images";
            }
        };
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                String message;
                int answer;
                File selectedFile = chooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                if (!path.toLowerCase().endsWith(".png")) {
                    path = path + ".png";
                    selectedFile = new File(path);
                }
                if (selectedFile.exists() && (answer = JOptionPane.showConfirmDialog(this, message = "File [" + selectedFile.getName() + "] already exists. Do you want to overwrite it?", "File exists", 0)) == 1) {
                    return;
                }
                String absolutePath = selectedFile.getAbsolutePath();
                byte[] data = this.rrdGraph.getRrdGraphInfo().getBytes();
                RandomAccessFile f = new RandomAccessFile(absolutePath, "rw");
                try {
                    f.write(data);
                }
                finally {
                    f.close();
                }
            }
            catch (IOException e) {
                Util.error((Component)this, "Could not save graph to file:\n" + e);
            }
        }
    }

    class GraphComboItem {
        private String description;
        private int dsIndex;
        private int arcIndex;

        GraphComboItem(String description, int dsIndex, int arcIndex) {
            this.description = description;
            this.dsIndex = dsIndex;
            this.arcIndex = arcIndex;
        }

        public String toString() {
            return this.description;
        }

        int getDsIndex() {
            return this.dsIndex;
        }

        int getArcIndex() {
            return this.arcIndex;
        }
    }

    final class GraphPanel
    extends JPanel {
        GraphPanel() {
        }

        public void paintComponent(Graphics g) {
            if (GraphFrame.this.rrdGraph != null) {
                GraphFrame.this.rrdGraph.render(g);
            }
        }
    }
}

