/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.insight.log.LogEvent;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.support.MavenCoordinates;
import org.fusesource.insight.log.support.Predicate;
import org.fusesource.insight.log.support.Strings;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Logs {
    private static Map<String, String> MAVEN_COORDINATES = new ConcurrentHashMap<String, String>();

    public static LogEvent newInstance(PaxLoggingEvent event) {
        PaxLocationInfo locationInformation;
        LogEvent answer = new LogEvent();
        answer.setLevel(Logs.toString(event.getLevel()));
        answer.setMessage(event.getMessage());
        answer.setLogger(event.getLoggerName());
        answer.setTimestamp(new Date(event.getTimeStamp()));
        answer.setThread(event.getThreadName());
        answer.setException(Logs.addMavenCoord(event.getThrowableStrRep()));
        Map eventProperties = event.getProperties();
        if (eventProperties != null && eventProperties.size() > 0) {
            String mavenCoord;
            HashMap<String, String> properties = new HashMap<String, String>();
            Set set = eventProperties.entrySet();
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                properties.put(Logs.toString(key), Logs.toString(value));
            }
            if (properties.get("maven.coordinates") == null && (mavenCoord = Logs.getMavenCoordinates(event)) != null && !mavenCoord.isEmpty()) {
                properties.put("maven.coordinates", mavenCoord);
            }
            answer.setProperties(properties);
        }
        if ((locationInformation = event.getLocationInformation()) != null) {
            answer.setClassName(locationInformation.getClassName());
            answer.setFileName(locationInformation.getFileName());
            answer.setMethodName(locationInformation.getMethodName());
            answer.setLineNumber(locationInformation.getLineNumber());
        }
        return answer;
    }

    protected static String toString(Object value) {
        return value.toString();
    }

    public static Predicate<PaxLoggingEvent> createPredicate(LogFilter filter) {
        String matchesText;
        Long after;
        Long before;
        if (filter == null) {
            return null;
        }
        final ArrayList<Predicate<PaxLoggingEvent>> predicates = new ArrayList<Predicate<PaxLoggingEvent>>();
        final Set<String> levels = filter.getLevelsSet();
        if (levels.size() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    PaxLevel level = event.getLevel();
                    return level != null && levels.contains(level.toString());
                }
            });
        }
        if ((before = filter.getBeforeTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time < before;
                }
            });
        }
        if ((after = filter.getAfterTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time > after;
                }
            });
        }
        if ((matchesText = filter.getMatchesText()) != null && matchesText.length() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    if (Strings.contains(matchesText, event.getFQNOfLoggerClass(), event.getMessage(), event.getLoggerName(), event.getThreadName())) {
                        return true;
                    }
                    String[] throwableStrRep = event.getThrowableStrRep();
                    if (throwableStrRep != null && Strings.contains(matchesText, throwableStrRep)) {
                        return true;
                    }
                    Map properties = event.getProperties();
                    return properties != null && Strings.contains(matchesText, properties.toString());
                }
            });
        }
        if (predicates.size() == 0) {
            return null;
        }
        if (predicates.size() == 1) {
            return (Predicate)predicates.get(0);
        }
        return new Predicate<PaxLoggingEvent>(){

            public String toString() {
                return "AndPredicate" + predicates;
            }

            @Override
            public boolean matches(PaxLoggingEvent event) {
                for (Predicate predicate : predicates) {
                    if (predicate.matches(event)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static String[] addMavenCoord(String[] throwable) {
        if (throwable != null) {
            String[] newThrowable = new String[throwable.length];
            for (int i = 0; i < newThrowable.length; ++i) {
                newThrowable[i] = Logs.addMavenCoord(throwable[i]);
            }
            return newThrowable;
        }
        return throwable;
    }

    private static String addMavenCoord(String line) {
        String idStr;
        String mvn;
        String str;
        int index;
        if (line.endsWith("]") && (index = line.lastIndexOf(91)) > 0 && (index = (str = line.substring(index + 1, line.length() - 1)).indexOf(58)) > 0 && (mvn = Logs.getMavenCoordinates(idStr = str.substring(0, index))) != null) {
            return line + "[" + mvn + "]";
        }
        return line;
    }

    private static String getMavenCoordinates(PaxLoggingEvent event) {
        Object id;
        Map props = event.getProperties();
        Object object = id = props != null ? (Object)props.get("bundle.id") : null;
        if (id == null) {
            return null;
        }
        return Logs.getMavenCoordinates(id.toString());
    }

    private static String getMavenCoordinates(String bundleIdStr) {
        long bundleId;
        try {
            bundleId = Long.parseLong(bundleIdStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return Logs.getMavenCoordinates(bundleId);
    }

    private static String getMavenCoordinates(long bundleId) {
        Bundle m_bundle = FrameworkUtil.getBundle(Logs.class).getBundleContext().getBundle(bundleId);
        if (m_bundle == null) {
            return null;
        }
        String id = Long.toString(m_bundle.getBundleId()) + ":" + Long.toString(m_bundle.getLastModified());
        String maven = MAVEN_COORDINATES.get(id);
        if (maven == null) {
            try {
                Enumeration e = m_bundle.findEntries("META-INF/maven/", "pom.properties", true);
                StringBuilder buf = new StringBuilder();
                while (e != null && e.hasMoreElements()) {
                    URL url = (URL)e.nextElement();
                    MavenCoordinates.appendMavenCoordinateFromPomProperties(url.openStream(), buf);
                }
                maven = buf.toString();
            }
            catch (Throwable t) {
                maven = "";
            }
            MAVEN_COORDINATES.put(id, maven);
        }
        return maven;
    }
}

