/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class EC2GetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    private final EC2Client client;
    private final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;

    @Inject
    protected EC2GetNodeMetadataStrategy(EC2Client client, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata) {
        this.client = (EC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.runningInstanceToNodeMetadata = (Function)Preconditions.checkNotNull(runningInstanceToNodeMetadata, (Object)"runningInstanceToNodeMetadata");
    }

    public NodeMetadata getNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        try {
            RunningInstance runningInstance = this.getRunningInstanceInRegion(region, instanceId);
            return (NodeMetadata)this.runningInstanceToNodeMetadata.apply((Object)runningInstance);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public RunningInstance getRunningInstanceInRegion(String region, String id) {
        return (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat(this.client.getInstanceServices().describeInstancesInRegion(region, id)));
    }
}

