/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.Resource;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.logging.Logger;

@Singleton
public class VolumeDetached
implements Predicate<Attachment> {
    private final ElasticBlockStoreClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VolumeDetached(ElasticBlockStoreClient client) {
        this.client = client;
    }

    public boolean apply(Attachment attachment) {
        this.logger.trace("looking for volume %s", new Object[]{attachment.getVolumeId()});
        Volume volume = (Volume)Iterables.getOnlyElement(this.client.describeVolumesInRegion(attachment.getRegion(), attachment.getVolumeId()));
        if (volume.getAttachments().size() == 0) {
            return true;
        }
        Attachment lastAttachment = (Attachment)Iterables.getLast(volume.getAttachments());
        this.logger.trace("%s: looking for status %s: currently: %s", new Object[]{lastAttachment, Attachment.Status.DETACHED, lastAttachment.getStatus()});
        return lastAttachment.getStatus() == Attachment.Status.DETACHED;
    }
}

