/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.fusesource.fabric.zookeeper.internal.BaseManagedServiceFactory;
import org.osgi.framework.BundleContext;

public class ZKServerFactoryBean
extends BaseManagedServiceFactory<Object> {
    public ZKServerFactoryBean(BundleContext context) {
        super(context, "ZooKeeper Server Factory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doCreate(Dictionary properties) throws Exception {
        this.LOGGER.info("Creating zookeeper server with properties: {}", (Object)properties);
        Properties props = new Properties();
        Enumeration ek = properties.keys();
        while (ek.hasMoreElements()) {
            Object key = ek.nextElement();
            Object val = properties.get(key);
            props.put(key.toString(), val != null ? val.toString() : "");
        }
        String serverId = props.getProperty("server.id");
        if (serverId != null) {
            props.remove("server.id");
            File myId = new File(props.getProperty("dataDir"), "myid");
            if (myId.exists() && !myId.delete()) {
                throw new IOException("Failed to delete " + myId);
            }
            if (myId.getParentFile() == null || !myId.getParentFile().exists() && !myId.getParentFile().mkdirs()) {
                throw new IOException("Failed to create " + myId.getParent());
            }
            FileOutputStream fos = new FileOutputStream(myId);
            try {
                fos.write((serverId + "\n").getBytes());
            }
            finally {
                fos.close();
            }
        }
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(props);
        if (!config.getServers().isEmpty()) {
            NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
            cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            QuorumPeer quorumPeer = new QuorumPeer();
            quorumPeer.setClientPortAddress(config.getClientPortAddress());
            quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir())));
            quorumPeer.setQuorumPeers(config.getServers());
            quorumPeer.setElectionType(config.getElectionAlg());
            quorumPeer.setMyid(config.getServerId());
            quorumPeer.setTickTime(config.getTickTime());
            quorumPeer.setMinSessionTimeout(config.getMinSessionTimeout());
            quorumPeer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            quorumPeer.setInitLimit(config.getInitLimit());
            quorumPeer.setSyncLimit(config.getSyncLimit());
            quorumPeer.setQuorumVerifier(config.getQuorumVerifier());
            quorumPeer.setCnxnFactory((ServerCnxnFactory)cnxnFactory);
            quorumPeer.setZKDatabase(new ZKDatabase(quorumPeer.getTxnFactory()));
            quorumPeer.setLearnerType(config.getPeerType());
            try {
                this.LOGGER.debug("Starting quorum peer \"%s\" on address %s", (Object)quorumPeer.getMyid(), (Object)config.getClientPortAddress());
                quorumPeer.start();
                this.LOGGER.debug("Started quorum peer \"%s\"", (Object)quorumPeer.getMyid());
            }
            catch (Exception e) {
                this.LOGGER.warn(String.format("Failed to start quorum peer \"%s\", reason : %s ", quorumPeer.getMyid(), e.getMessage()));
                quorumPeer.shutdown();
                throw e;
            }
            return new ClusteredServer(quorumPeer);
        }
        ServerConfig cfg = new ServerConfig();
        cfg.readFrom(config);
        ZooKeeperServer zkServer = new ZooKeeperServer();
        FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(cfg.getDataLogDir()), new File(cfg.getDataDir()));
        zkServer.setTxnLogFactory(ftxn);
        zkServer.setTickTime(cfg.getTickTime());
        zkServer.setMinSessionTimeout(cfg.getMinSessionTimeout());
        zkServer.setMaxSessionTimeout(cfg.getMaxSessionTimeout());
        NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
        cnxnFactory.configure(cfg.getClientPortAddress(), cfg.getMaxClientCnxns());
        try {
            this.LOGGER.debug("Starting ZooKeeper server on address %s", (Object)config.getClientPortAddress());
            cnxnFactory.startup(zkServer);
            this.LOGGER.debug("Started ZooKeeper server");
        }
        catch (Exception e) {
            this.LOGGER.warn(String.format("Failed to start ZooKeeper server, reason : %s", e));
            cnxnFactory.shutdown();
            throw e;
        }
        return new SimpleServer(zkServer, cnxnFactory);
    }

    @Override
    protected void doDestroy(Object obj) throws Exception {
        this.LOGGER.info("Destroying zookeeper server");
        ((Destroyable)obj).destroy();
    }

    @Override
    protected String[] getExposedClasses(Object obj) {
        if (obj instanceof ServerStats.Provider) {
            return new String[]{ServerStats.Provider.class.getName()};
        }
        if (obj instanceof QuorumStats.Provider) {
            return new String[]{QuorumStats.Provider.class.getName()};
        }
        throw new IllegalStateException("Unsupported service type: " + obj.getClass().toString());
    }

    static class ClusteredServer
    implements Destroyable,
    QuorumStats.Provider {
        private final QuorumPeer peer;

        ClusteredServer(QuorumPeer peer) {
            this.peer = peer;
        }

        @Override
        public void destroy() throws Exception {
            this.peer.shutdown();
            this.peer.join();
        }

        public String[] getQuorumPeers() {
            return this.peer.getQuorumPeers();
        }

        public String getServerState() {
            return this.peer.getServerState();
        }
    }

    static class SimpleServer
    implements Destroyable,
    ServerStats.Provider {
        private final ZooKeeperServer server;
        private final NIOServerCnxnFactory cnxnFactory;

        SimpleServer(ZooKeeperServer server, NIOServerCnxnFactory cnxnFactory) {
            this.server = server;
            this.cnxnFactory = cnxnFactory;
        }

        @Override
        public void destroy() throws Exception {
            this.cnxnFactory.shutdown();
            this.cnxnFactory.join();
        }

        public long getOutstandingRequests() {
            return this.server.getOutstandingRequests();
        }

        public long getLastProcessedZxid() {
            return this.server.getLastProcessedZxid();
        }

        public String getState() {
            return this.server.getState();
        }
    }

    static interface Destroyable {
        public void destroy() throws Exception;
    }
}

