/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="container-info", scope="fabric", description="Dispalys information about the containers")
public class ContainerInfo
extends FabricCommand {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="container", description="The name of the container container.", required=false, multiValued=false)
    private String containerName = System.getProperty("karaf.name");

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.containerName);
        if (!this.containerExists(this.containerName)) {
            System.out.println("Container " + this.containerName + " does not exists!");
            return null;
        }
        Container container = this.fabricService.getContainer(this.containerName);
        System.out.println(String.format(FORMAT, "Name:", container.getId()));
        System.out.println(String.format(FORMAT, "Version:", container.getVersion()));
        System.out.println(String.format(FORMAT, "Alive:", container.isAlive()));
        System.out.println(String.format(FORMAT, "Resolver:", container.getResolver()));
        System.out.println(String.format(FORMAT, "Network Address:", container.getIp()));
        System.out.println(String.format(FORMAT, "SSH Url:", container.getSshUrl()));
        System.out.println(String.format(FORMAT, "JMX Url:", container.getJmxUrl()));
        StringBuilder sb = new StringBuilder();
        Profile[] profiles = container.getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(profiles[i].getId());
        }
        System.out.println(String.format(FORMAT, "Profiles:", sb.toString()));
        System.out.println(String.format(FORMAT, "Provision Status:", container.getProvisionStatus()));
        if (container.getProvisionException() != null) {
            System.out.println(String.format(FORMAT, "Provision Error:", container.getProvisionException()));
        }
        return null;
    }

    private boolean containerExists(String containerName) {
        Container[] containers;
        for (Container c : containers = this.fabricService.getContainers()) {
            if (!containerName.equals(c.getId())) continue;
            return true;
        }
        return false;
    }
}

