/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jclouds.collect.AbstractMapEntry;

public class TransformingMap<K, V1, V2>
extends AbstractMap<K, V2> {
    final Map<K, V1> fromMap;
    final Function<? super V1, V2> getFunction;
    final Function<? super V2, V1> putFunction;

    public TransformingMap(Map<K, V1> fromMap, Function<? super V1, V2> getFunction, Function<? super V2, V1> putFunction) {
        this.fromMap = (Map)Preconditions.checkNotNull(fromMap);
        this.getFunction = (Function)Preconditions.checkNotNull(getFunction);
        this.putFunction = (Function)Preconditions.checkNotNull(putFunction);
    }

    @Override
    public int size() {
        return this.fromMap.size();
    }

    @Override
    public V2 put(K key, V2 value) {
        V2 old = this.get(key);
        this.fromMap.put(key, value != null ? this.putFunction.apply(value) : null);
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fromMap.containsKey(key);
    }

    @Override
    public V2 get(Object key) {
        V1 value = this.fromMap.get(key);
        return (V2)(value != null || this.fromMap.containsKey(key) ? this.getFunction.apply(value) : null);
    }

    @Override
    public V2 remove(Object key) {
        return (V2)(this.fromMap.containsKey(key) ? this.getFunction.apply(this.fromMap.remove(key)) : null);
    }

    @Override
    public void clear() {
        this.fromMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V2>> entrySet() {
        return new EntrySet();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V2>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return TransformingMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V2>> iterator() {
            final Iterator mapIterator = TransformingMap.this.fromMap.entrySet().iterator();
            return new Iterator<Map.Entry<K, V2>>(){

                @Override
                public boolean hasNext() {
                    return mapIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V2> next() {
                    final Map.Entry entry = (Map.Entry)mapIterator.next();
                    return new AbstractMapEntry<K, V2>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V2 getValue() {
                            return TransformingMap.this.getFunction.apply(entry.getValue());
                        }
                    };
                }

                @Override
                public void remove() {
                    mapIterator.remove();
                }
            };
        }

        @Override
        public void clear() {
            TransformingMap.this.fromMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            Object mapValue = TransformingMap.this.get(entryKey);
            if (mapValue != null) {
                return mapValue.equals(entryValue);
            }
            return entryValue == null && TransformingMap.this.containsKey(entryKey);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                TransformingMap.this.fromMap.remove(key);
                return true;
            }
            return false;
        }
    }
}

