/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeoutException;
import org.jclouds.util.Throwables2;

public class RetryOnTimeOutExceptionSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;

    public RetryOnTimeOutExceptionSupplier(Supplier<T> delegate) {
        this.delegate = (Supplier)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    public T get() {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                ex = null;
                return (T)this.delegate.get();
            }
            catch (Exception e) {
                ex = Throwables2.getFirstThrowableOfType(e, TimeoutException.class);
                if (ex != null) continue;
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (ex != null) {
            Throwables.propagate(ex);
        }
        assert (false);
        return null;
    }

    public String toString() {
        return "RetryOnTimeOutExceptionSupplier(" + this.delegate + ")";
    }
}

