/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;

public class LocationBuilder {
    protected LocationScope scope;
    protected String id;
    protected String description;
    protected Location parent;
    protected Set<String> iso3166Codes = ImmutableSet.of();
    protected Map<String, Object> metadata = ImmutableMap.of();

    public LocationBuilder scope(LocationScope scope) {
        this.scope = scope;
        return this;
    }

    public LocationBuilder id(String id) {
        this.id = id;
        return this;
    }

    public LocationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public LocationBuilder parent(Location parent) {
        this.parent = parent;
        return this;
    }

    public LocationBuilder iso3166Codes(Iterable<String> iso3166Codes) {
        this.iso3166Codes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(iso3166Codes, (Object)"iso3166Codes")));
        return this;
    }

    public LocationBuilder metadata(Map<String, Object> metadata) {
        this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
        return this;
    }

    public Location build() {
        return new LocationImpl(this.scope, this.id, this.description, this.parent, this.iso3166Codes, this.metadata);
    }
}

