/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public abstract class BasePayload<V>
implements Payload {
    protected final V content;
    protected volatile transient boolean written;
    protected MutableContentMetadata contentMetadata;

    protected BasePayload(V content) {
        this(content, new BaseMutableContentMetadata());
    }

    protected BasePayload(V content, MutableContentMetadata contentMetadata) {
        this.content = Preconditions.checkNotNull(content, (Object)"content");
        this.contentMetadata = (MutableContentMetadata)Preconditions.checkNotNull((Object)contentMetadata, (Object)"contentMetadata");
    }

    public V getRawContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        Preconditions.checkState((!this.written || this.isRepeatable() ? 1 : 0) != 0, (Object)"can only write to an outputStream once");
        this.written = true;
        InputStream in = this.getInput();
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)outstream);
            outstream.flush();
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payload)) {
            return false;
        }
        Payload other = (Payload)obj;
        return !(this.content == null ? other.getRawContent() != null : !this.content.equals(other.getRawContent()));
    }

    public String toString() {
        return "[content=" + (this.content != null) + ", contentMetadata=" + this.contentMetadata + ", written=" + this.written + "]";
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata in) {
        this.contentMetadata = in;
    }
}

