/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Preconditions;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jclouds.json.internal.NamingStrategies;

public final class DeserializationConstructorAndReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final NamingStrategies.ConstructorFieldNamingStrategy constructorFieldNamingPolicy;
    private final ReflectiveTypeAdapterFactory delegateFactory;

    public DeserializationConstructorAndReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy serializationFieldNamingPolicy, Excluder excluder, NamingStrategies.ConstructorFieldNamingStrategy deserializationFieldNamingPolicy) {
        this.constructorFieldNamingPolicy = (NamingStrategies.ConstructorFieldNamingStrategy)Preconditions.checkNotNull((Object)deserializationFieldNamingPolicy, (Object)"deserializationFieldNamingPolicy");
        this.delegateFactory = new ReflectiveTypeAdapterFactory(constructorConstructor, (FieldNamingStrategy)Preconditions.checkNotNull((Object)serializationFieldNamingPolicy, (Object)"fieldNamingPolicy"), (Excluder)Preconditions.checkNotNull((Object)excluder, (Object)"excluder"));
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class raw = type.getRawType();
        Constructor deserializationCtor = this.constructorFieldNamingPolicy.getDeserializationConstructor(raw);
        if (deserializationCtor == null) {
            return null;
        }
        deserializationCtor.setAccessible(true);
        return new DeserializeWithParameterizedConstructorSerializeWithDelegate(this.delegateFactory.create(gson, type), deserializationCtor, this.getParameterReaders(gson, type, deserializationCtor));
    }

    private Map<String, ParameterReader> getParameterReaders(Gson context, TypeToken<?> declaring, Constructor<?> constructor) {
        LinkedHashMap<String, ParameterReader> result = new LinkedHashMap<String, ParameterReader>();
        for (int index = 0; index < constructor.getGenericParameterTypes().length; ++index) {
            Type parameterType = this.getTypeOfConstructorParameter(declaring, constructor, index);
            TypeAdapter adapter = context.getAdapter(TypeToken.get((Type)parameterType));
            String parameterName = this.constructorFieldNamingPolicy.translateName(constructor, index);
            Preconditions.checkArgument((parameterName != null ? 1 : 0) != 0, (Object)(constructor + " parameter " + 0 + " failed to be named by " + this.constructorFieldNamingPolicy));
            ParameterReader parameterReader = new ParameterReader(parameterName, index, adapter);
            ParameterReader previous = result.put(parameterReader.name, parameterReader);
            Preconditions.checkArgument((previous == null ? 1 : 0) != 0, (Object)(constructor + " declares multiple JSON parameters named " + parameterReader.name));
        }
        return result;
    }

    private Type getTypeOfConstructorParameter(TypeToken<?> declaring, Constructor<?> constructor, int index) {
        Type genericParameter = constructor.getGenericParameterTypes()[index];
        return .Gson.Types.resolve((Type)declaring.getType(), (Class)declaring.getRawType(), (Type)genericParameter);
    }

    static class ParameterReader<T> {
        final String name;
        final int index;
        final TypeAdapter<T> typeAdapter;

        ParameterReader(String name, int index, TypeAdapter<T> typeAdapter) {
            this.name = name;
            this.index = index;
            this.typeAdapter = typeAdapter;
        }

        public Object read(JsonReader reader) throws IOException {
            return this.typeAdapter.read(reader);
        }
    }

    private final class DeserializeWithParameterizedConstructorSerializeWithDelegate<T>
    extends TypeAdapter<T> {
        private final Constructor<? super T> parameterizedCtor;
        private final Map<String, ParameterReader> parameterReaders;
        private final TypeAdapter<T> delegate;

        private DeserializeWithParameterizedConstructorSerializeWithDelegate(TypeAdapter<T> delegate, Constructor<? super T> parameterizedCtor, Map<String, ParameterReader> parameterReaders) {
            this.delegate = delegate;
            this.parameterizedCtor = parameterizedCtor;
            this.parameterReaders = parameterReaders;
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Class<?>[] paramTypes = this.parameterizedCtor.getParameterTypes();
            Object[] ctorParams = new Object[paramTypes.length];
            boolean empty = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == Boolean.TYPE) {
                    ctorParams[i] = Boolean.FALSE;
                    continue;
                }
                if (!paramTypes[i].isPrimitive()) continue;
                ctorParams[i] = 0;
            }
            try {
                in.beginObject();
                while (in.hasNext()) {
                    empty = false;
                    String name = in.nextName();
                    ParameterReader parameter = this.parameterReaders.get(name);
                    if (parameter == null) {
                        in.skipValue();
                        continue;
                    }
                    Object value = parameter.read(in);
                    if (value == null) continue;
                    ctorParams[parameter.index] = value;
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].isPrimitive()) continue;
                Preconditions.checkArgument((ctorParams[i] != null ? 1 : 0) != 0, (Object)("Primitive param[" + i + "] in constructor " + this.parameterizedCtor + " cannot be absent!"));
            }
            in.endObject();
            try {
                return this.newInstance(ctorParams);
            }
            catch (NullPointerException ex) {
                if (empty && paramTypes.length > 0) {
                    return null;
                }
                throw ex;
            }
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }

        private T newInstance(Object[] ctorParams) throws AssertionError {
            try {
                return this.parameterizedCtor.newInstance(ctorParams);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)RuntimeException.class.cast(e.getCause());
                }
                throw new AssertionError((Object)e);
            }
        }
    }
}

