/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class LocationIdToURIFromConfigurationOrDefaultToProvider
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ValueOfConfigurationKeyOrNull config;
    protected final Supplier<Set<String>> locationIds;
    protected final Supplier<URI> providerURI;
    protected final String configPrefix;

    @Inject
    public LocationIdToURIFromConfigurationOrDefaultToProvider(ValueOfConfigurationKeyOrNull config, @Provider Supplier<URI> providerURI, @Assisted Supplier<Set<String>> locationIds, @Assisted String configPrefix) {
        this.config = config;
        this.locationIds = locationIds;
        this.providerURI = providerURI;
        this.configPrefix = configPrefix;
    }

    public Map<String, Supplier<URI>> get() {
        ImmutableMap.Builder locations = ImmutableMap.builder();
        for (String location : (Set)this.locationIds.get()) {
            String configKey = this.configPrefix + "." + location + "." + "endpoint";
            String locationUri = this.config.apply(configKey);
            if (locationUri == null) {
                this.logger.debug("config key %s not present, defaulting to %s", configKey, this.providerURI);
                locations.put((Object)location, this.providerURI);
                continue;
            }
            locations.put((Object)location, (Object)Suppliers.ofInstance((Object)URI.create(locationUri)));
        }
        return locations.build();
    }
}

