/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.elasticsearch;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSender
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSender.class);
    private Node node;
    private int max = 1000;
    private Thread thread;
    private volatile boolean running;
    private BlockingQueue<IndexRequest> queue = new LinkedBlockingQueue<IndexRequest>();

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void init() {
        this.running = true;
        this.thread = new Thread((Runnable)this, "ElasticSender");
        this.thread.start();
    }

    public void destroy() {
        this.running = false;
        this.thread.interrupt();
    }

    public void put(IndexRequest data) {
        this.queue.add(data);
    }

    public void createIndexIfNeeded(CreateIndexRequest request) {
        try {
            this.node.client().admin().indices().create(request).actionGet();
        }
        catch (IndexAlreadyExistsException indexAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                IndexRequest req = this.queue.take();
                BulkRequest bulk = new BulkRequest();
                for (int nb = 0; req != null && (nb == 0 || nb < this.max); ++nb) {
                    bulk.add(req);
                    req = (IndexRequest)this.queue.poll();
                }
                if (bulk.numberOfActions() <= 0) continue;
                BulkResponse rep = (BulkResponse)this.node.client().bulk(bulk).actionGet();
                for (BulkItemResponse bir : rep.items()) {
                    if (!bir.failed()) continue;
                    LOGGER.warn("Error indexing item: {}", (Object)bir.getFailureMessage());
                }
            }
            catch (Exception e) {
                if (!this.running) continue;
                LOGGER.warn("Error while sending indexes", (Throwable)e);
            }
        }
    }

    public static void quote(String string, StringBuilder w) {
        if (string == null || string.length() == 0) {
            w.append("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        w.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.append('\\');
                    w.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.append('\\');
                    }
                    w.append(c);
                    continue block9;
                }
                case '\b': {
                    w.append("\\b");
                    continue block9;
                }
                case '\t': {
                    w.append("\\t");
                    continue block9;
                }
                case '\n': {
                    w.append("\\n");
                    continue block9;
                }
                case '\f': {
                    w.append("\\f");
                    continue block9;
                }
                case '\r': {
                    w.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hhhh = "000" + Integer.toHexString(c);
                        w.append("\\u" + hhhh.substring(hhhh.length() - 4));
                        continue block9;
                    }
                    w.append(c);
                }
            }
        }
        w.append('\"');
    }
}

