/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.commands;

import com.google.common.base.Strings;
import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.JarInstallParameters;
import org.fusesource.process.manager.commands.support.InstallSupport;

@Command(name="install-jar", scope="process", description="Installs a jar as managed process into this container.")
public class InstallJar
extends InstallSupport {
    @Option(name="-c", aliases={"--classifier"}, required=false, description="The maven jar classifier")
    protected String classifier;
    @Option(name="-e", aliases={"--extension"}, required=false, description="The maven extension (defaults to jar)")
    protected String extension;
    @Option(name="-o", aliases={"--offline"}, required=false, description="Whether to use offline mode when resolving dependencies")
    protected boolean offline;
    @Option(name="-opt", aliases={"--optional"}, required=false, multiValued=true, description="List of patterns of optional dependencies to include. Of the form group[:artifact] with * allowed as wildard")
    protected String[] optionalDependencyPatterns;
    @Option(name="-exc", aliases={"--exclude"}, required=false, multiValued=true, description="List of patterns of dependencies to exclude. Of the form group[:artifact] with * allowed as wildard")
    protected String[] excludeDependencyPatterns;
    @Option(name="-m", aliases={"--main"}, required=false, description="The Java executable main() class")
    protected String mainClass;
    @Argument(index=0, required=true, name="groupId", description="The maven group Id of the jar")
    protected String groupId;
    @Argument(index=1, required=true, name="artifactId", description="The maven artifact Id of the jar")
    protected String artifactId;
    @Argument(index=2, required=false, name="version", description="The maven version Id of the jar")
    protected String version;

    protected Object doExecute() throws Exception {
        this.checkRequirements();
        URL controllerUrl = this.getControllerURL();
        JarInstallParameters parameters = new JarInstallParameters();
        parameters.setControllerJson(controllerUrl);
        parameters.setGroupId(this.groupId);
        parameters.setArtifactId(this.artifactId);
        parameters.setVersion(this.version);
        parameters.setClassifier(this.classifier);
        if (!Strings.isNullOrEmpty((String)this.extension)) {
            parameters.setExtension(this.extension);
        }
        parameters.setOffline(this.offline);
        if (this.optionalDependencyPatterns != null) {
            parameters.setOptionalDependencyPatterns(this.optionalDependencyPatterns);
        }
        if (this.excludeDependencyPatterns != null) {
            parameters.setExcludeDependencyFilterPatterns(this.excludeDependencyPatterns);
        }
        if (this.mainClass != null) {
            parameters.setMainClass(this.mainClass);
        }
        Installation install = this.getProcessManager().installJar(parameters);
        System.out.println("Installed process " + install.getId() + " to " + install.getInstallDir());
        return null;
    }
}

