/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds;

import java.util.Dictionary;
import java.util.Enumeration;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudProviderBridge
implements LifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudProviderBridge.class);
    private static final String COMPUTE_FILTER = "(service.factoryPid=org.jclouds.compute)";
    private static final String BLOBSTORE_FILTER = "(service.factoryPid=org.jclouds.blobstore)";
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;

    public void onConnected() {
        this.registerServices(COMPUTE_FILTER);
        this.registerServices(BLOBSTORE_FILTER);
    }

    public void onDisconnected() {
    }

    public void registerServices(String filter) {
        try {
            Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    String credential;
                    Dictionary properties = configuration.getProperties();
                    if (properties == null) continue;
                    String name = properties.get("name") != null ? String.valueOf(properties.get("name")) : null;
                    String identity = properties.get("identity") != null ? String.valueOf(properties.get("identity")) : null;
                    String string = credential = properties.get("credential") != null ? String.valueOf(properties.get("credential")) : null;
                    if (name == null || identity == null || credential == null || !this.getZooKeeper().isConnected() || this.getZooKeeper().exists(ZkPath.CLOUD_SERVICE.getPath(new String[]{name})) != null) continue;
                    ZooKeeperUtils.create((IZKClient)this.getZooKeeper(), (String)ZkPath.CLOUD_SERVICE.getPath(new String[]{name}));
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = String.valueOf(keys.nextElement());
                        String value = String.valueOf(properties.get(key));
                        if (key.equals("service.pid") || key.equals("service.factoryPid")) continue;
                        ZooKeeperUtils.set((IZKClient)this.getZooKeeper(), (String)ZkPath.CLOUD_SERVICE_PROPERTY.getPath(new String[]{name, key}), (String)value);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve compute service information from configuration admin.", (Throwable)e);
        }
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

