/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.CreateRemoteContainerOptions;
import org.fusesource.fabric.internal.ContainerProviderUtils;
import org.fusesource.fabric.service.jclouds.CloudContainerInstallationTask;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.internal.CloudUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsContainerProvider
implements ContainerProvider<CreateJCloudsContainerOptions, CreateJCloudsContainerMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcloudsContainerProvider.class);
    private final ConcurrentMap<String, ComputeService> computeServiceMap = new ConcurrentHashMap<String, ComputeService>();
    private FirewallManagerFactory firewallManagerFactory;
    private CredentialStore credentialStore;
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private BundleContext bundleContext;
    private ServiceReference computeReference = null;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public synchronized void bind(ComputeService computeService) {
        String name;
        if (computeService != null && (name = computeService.getContext().unwrap().getName()) != null) {
            this.computeServiceMap.put(name, computeService);
        }
    }

    public void unbind(ComputeService computeService) {
        String serviceId;
        if (computeService != null && (serviceId = computeService.getContext().unwrap().getName()) != null) {
            this.computeServiceMap.remove(serviceId);
        }
    }

    public void destroy() {
        if (this.computeReference != null) {
            this.bundleContext.ungetService(this.computeReference);
        }
    }

    public ConcurrentMap<String, ComputeService> getComputeServiceMap() {
        return this.computeServiceMap;
    }

    public Set<CreateJCloudsContainerMetadata> create(CreateJCloudsContainerOptions options) throws MalformedURLException, RunNodesException, URISyntaxException, InterruptedException {
        LinkedHashSet<CreateJCloudsContainerMetadata> result;
        block29: {
            result = new LinkedHashSet<CreateJCloudsContainerMetadata>();
            try {
                options.getCreationStateListener().onStateChange("Looking up for compute service.");
                ComputeService computeService = this.getOrCreateComputeService(options);
                if (Strings.isNullOrEmpty((String)options.getProviderName())) {
                    options.setProviderName(computeService.getContext().unwrap().getProviderMetadata().getId());
                }
                if (computeService == null) {
                    throw new IllegalStateException("Compute service could not be found or created.");
                }
                TemplateBuilder builder = computeService.templateBuilder();
                builder.any();
                if (options.getInstanceType() == null && Strings.isNullOrEmpty((String)options.getHardwareId())) {
                    builder.minRam(1024);
                } else if (!Strings.isNullOrEmpty((String)options.getHardwareId())) {
                    builder.hardwareId(options.getHardwareId());
                } else if (options.getInstanceType() != null) {
                    switch (options.getInstanceType()) {
                        case Smallest: {
                            builder.smallest();
                            break;
                        }
                        case Biggest: {
                            builder.biggest();
                            break;
                        }
                        case Fastest: {
                            builder.fastest();
                            break;
                        }
                        default: {
                            builder.fastest();
                        }
                    }
                }
                StringBuilder overviewBuilder = new StringBuilder();
                overviewBuilder.append(String.format("Creating %s nodes in the cloud. Using", options.getNumber()));
                if (!Strings.isNullOrEmpty((String)options.getImageId())) {
                    overviewBuilder.append(" image id: ").append(options.getImageId());
                    builder.imageId(options.getImageId());
                } else if (!Strings.isNullOrEmpty((String)options.getOsFamily())) {
                    overviewBuilder.append(" operating system: ").append(options.getOsFamily());
                    builder.osFamily(OsFamily.fromValue((String)options.getOsFamily()));
                    if (!Strings.isNullOrEmpty((String)options.getOsVersion())) {
                        overviewBuilder.append(" and version: ").append(options.getOsVersion());
                        builder.osVersionMatches(options.getOsVersion());
                    }
                } else {
                    throw new IllegalArgumentException("Required Image id or Operation System and version predicates.");
                }
                overviewBuilder.append(".");
                if (!Strings.isNullOrEmpty((String)options.getLocationId())) {
                    overviewBuilder.append(" On location: ").append(options.getLocationId()).append(".");
                    builder.locationId(options.getLocationId());
                }
                AdminAccess.Builder adminAccess = AdminAccess.builder();
                TemplateOptions templateOptions = computeService.templateOptions();
                this.applyProviderSpecificOptions(templateOptions, options);
                if (options.isAdminAccess()) {
                    if (!Strings.isNullOrEmpty((String)options.getPublicKeyFile())) {
                        File publicKey = new File(options.getPublicKeyFile());
                        if (publicKey.exists()) {
                            adminAccess.adminPublicKey(publicKey);
                        } else {
                            templateOptions.runScript((Statement)AdminAccess.standard());
                            LOGGER.warn("Public key has been specified file: {} files cannot be found. Ignoring.", (Object)publicKey.getAbsolutePath());
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)options.getUser())) {
                        adminAccess.adminUsername(options.getUser());
                    }
                    templateOptions.runScript((Statement)adminAccess.build());
                }
                builder = builder.options(templateOptions);
                Set metadatas = null;
                overviewBuilder.append(" It may take a while ...");
                options.getCreationStateListener().onStateChange(overviewBuilder.toString());
                metadatas = computeService.createNodesInGroup(options.getGroup(), options.getNumber().intValue(), builder.build());
                if (metadatas != null) {
                    for (NodeMetadata metadata : metadatas) {
                        options.getCreationStateListener().onStateChange(String.format("Node %s has been created.", metadata.getName()));
                    }
                }
                Thread.sleep(5000L);
                int suffix = 1;
                if (metadatas == null) break block29;
                String originalName = new String(options.getName());
                CountDownLatch countDownLatch = new CountDownLatch(options.getNumber());
                for (NodeMetadata nodeMetadata : metadatas) {
                    String containerName = options.getNumber() > 1 ? originalName + suffix++ : originalName;
                    CloudContainerInstallationTask installationTask = new CloudContainerInstallationTask(containerName, nodeMetadata, options, computeService, this.firewallManagerFactory, templateOptions, result, countDownLatch);
                    this.executorService.execute(installationTask);
                }
                countDownLatch.await(10L, TimeUnit.MINUTES);
            }
            catch (Throwable t) {
                if (options == null || options.getNumber() <= 0) break block29;
                for (int i = result.size(); i < options.getNumber(); ++i) {
                    CreateJCloudsContainerMetadata failureMetdata = new CreateJCloudsContainerMetadata();
                    failureMetdata.setFailure(t);
                    result.add(failureMetdata);
                }
            }
        }
        return result;
    }

    public void start(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        try {
            String nodeId = jCloudsContainerMetadata.getNodeId();
            ComputeService computeService = this.getOrCreateComputeService(options);
            NodeMetadata nodeMetadata = computeService.getNodeMetadata(nodeId);
            LoginCredentials credentials = nodeMetadata.getCredentials();
            if (options.getUser() != null) {
                LoginCredentials.Builder loginBuilder = credentials == null ? LoginCredentials.builder() : credentials.toBuilder();
                credentials = options.getPassword() != null ? loginBuilder.user(options.getUser()).password(options.getPassword()).build() : loginBuilder.user(options.getUser()).build();
            }
            String script = ContainerProviderUtils.buildStartScript((CreateRemoteContainerOptions)((CreateRemoteContainerOptions)options.name(container.getId())));
            ExecResponse response = null;
            response = credentials != null ? computeService.runScriptOnNode(nodeId, script, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false)) : computeService.runScriptOnNode(nodeId, script);
            if (response == null) {
                jCloudsContainerMetadata.setFailure((Throwable)new Exception("No response received for fabric install script."));
            } else if (response.getOutput() != null && response.getOutput().contains("Command Failed:")) {
                jCloudsContainerMetadata.setFailure((Throwable)new Exception(ContainerProviderUtils.parseScriptFailure((String)response.getOutput())));
            }
        }
        catch (Throwable t) {
            jCloudsContainerMetadata.setFailure(t);
        }
    }

    public void stop(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        try {
            String nodeId = jCloudsContainerMetadata.getNodeId();
            ComputeService computeService = this.getOrCreateComputeService(options);
            NodeMetadata nodeMetadata = computeService.getNodeMetadata(nodeId);
            LoginCredentials credentials = nodeMetadata.getCredentials();
            if (options.getUser() != null) {
                LoginCredentials.Builder loginBuilder = credentials == null ? LoginCredentials.builder() : credentials.toBuilder();
                credentials = options.getPassword() != null ? loginBuilder.user(options.getUser()).password(options.getPassword()).build() : loginBuilder.user(options.getUser()).build();
            }
            String script = ContainerProviderUtils.buildStopScript((CreateRemoteContainerOptions)((CreateRemoteContainerOptions)options.name(container.getId())));
            ExecResponse response = null;
            response = credentials != null ? computeService.runScriptOnNode(nodeId, script, RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false)) : computeService.runScriptOnNode(nodeId, script);
            if (response == null) {
                jCloudsContainerMetadata.setFailure((Throwable)new Exception("No response received for fabric install script."));
            } else if (response.getOutput() != null && response.getOutput().contains("Command Failed:")) {
                jCloudsContainerMetadata.setFailure((Throwable)new Exception(ContainerProviderUtils.parseScriptFailure((String)response.getOutput())));
            }
        }
        catch (Throwable t) {
            jCloudsContainerMetadata.setFailure(t);
        }
    }

    public void destroy(Container container) {
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        String nodeId = jCloudsContainerMetadata.getNodeId();
        ComputeService computeService = this.getOrCreateComputeService(options);
        computeService.destroyNode(nodeId);
    }

    public Map<String, String> parseQuery(String uri) throws URISyntaxException {
        try {
            HashMap<String, String> rc = new HashMap<String, String>();
            if (uri != null) {
                String[] parameters = uri.split("&");
                for (int i = 0; i < parameters.length; ++i) {
                    int p = parameters[i].indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                        String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameters[i], null);
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    private synchronized ComputeService getOrCreateComputeService(CreateJCloudsContainerOptions options) {
        ComputeService computeService = null;
        if (options != null) {
            Object object = options.getComputeService();
            if (object instanceof ComputeService) {
                computeService = (ComputeService)object;
            }
            if (computeService == null && options.getContextName() != null) {
                computeService = (ComputeService)this.computeServiceMap.get(options.getContextName());
            }
            if (computeService == null) {
                options.getCreationStateListener().onStateChange("Compute Service not found. Creating ...");
                if (Strings.isNullOrEmpty((String)options.getProviderName()) || Strings.isNullOrEmpty((String)options.getIdentity()) || Strings.isNullOrEmpty((String)options.getCredential())) {
                    throw new IllegalArgumentException("Cannot create compute service. A registered cloud provider or the provider name, identity and credential options are required");
                }
                Map serviceOptions = options.getServiceOptions();
                try {
                    if (options.getProviderName() != null) {
                        CloudUtils.registerProvider(this.zooKeeper, this.configurationAdmin, options.getContextName(), options.getProviderName(), options.getIdentity(), options.getCredential(), serviceOptions);
                    } else if (options.getApiName() != null) {
                        CloudUtils.registerApi(this.zooKeeper, this.configurationAdmin, options.getContextName(), options.getApiName(), options.getEndpoint(), options.getIdentity(), options.getCredential(), serviceOptions);
                    }
                    computeService = CloudUtils.waitForComputeService(this.bundleContext, options.getContextName());
                }
                catch (Exception e) {
                    LOGGER.warn("Did not manage to register compute cloud provider.");
                }
            }
        }
        if (computeService != null) {
            if (Strings.isNullOrEmpty((String)options.getProviderName())) {
                options.setProviderName(computeService.getContext().unwrap().getProviderMetadata().getId());
            }
            if (Strings.isNullOrEmpty((String)options.getApiName())) {
                options.setApiName(computeService.getContext().unwrap().getProviderMetadata().getApiMetadata().getId());
            }
        }
        return computeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String path) {
        byte[] bytes = null;
        FileInputStream fin = null;
        File file = new File(path);
        if (path != null && file.exists()) {
            try {
                fin = new FileInputStream(file);
                bytes = new byte[(int)file.length()];
                fin.read(bytes);
            }
            catch (IOException e) {
                LOGGER.warn("Error reading file {}.", (Object)path);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return new String(bytes);
    }

    private void applyProviderSpecificOptions(TemplateOptions templateOptions, CreateJCloudsContainerOptions options) {
        if (options != null && templateOptions != null) {
            for (Map.Entry entry : options.getNodeOptions().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Field field = templateOptions.getClass().getDeclaredField(key);
                    if (field == null) continue;
                    field.setAccessible(true);
                    field.set(templateOptions, value);
                }
                catch (Exception ex) {}
            }
        }
    }

    private void applyJavaRmiHostName(CreateJCloudsContainerOptions options, String publicAddress) {
        if (!Strings.isNullOrEmpty((String)publicAddress) && "publicip".equals(options.getResolver())) {
            String jvmOptions = Strings.isNullOrEmpty((String)options.getJvmOpts()) ? "" : options.getJvmOpts().trim() + " ";
            jvmOptions = jvmOptions + "-Djava.rmi.server.hostname=" + publicAddress;
            options.setJvmOpts(jvmOptions);
        }
    }

    public FirewallManagerFactory getFirewallManagerFactory() {
        return this.firewallManagerFactory;
    }

    public void setFirewallManagerFactory(FirewallManagerFactory firewallManagerFactory) {
        this.firewallManagerFactory = firewallManagerFactory;
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public void setCredentialStore(CredentialStore credentialStore) {
        this.credentialStore = credentialStore;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

