/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    private static StringBuffer m_sb = new StringBuffer();

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnderlineString(String s) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            m_sb.delete(0, m_sb.length());
            for (int i = 0; i < s.length(); ++i) {
                m_sb.append('-');
            }
            return m_sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueString(Object obj) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                String[] array = (String[])obj;
                return Util.convertTypedArrayToString(array, new StringConverter<String>(){

                    @Override
                    public String convertObjectToString(String toConvert) {
                        return toConvert;
                    }
                });
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString();
            }
            if (obj instanceof Long) {
                return ((Long)obj).toString();
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).toString();
            }
            if (obj instanceof Short) {
                return ((Short)obj).toString();
            }
            if (obj instanceof Double) {
                return ((Double)obj).toString();
            }
            if (obj instanceof Float) {
                return ((Float)obj).toString();
            }
            if (obj instanceof URL) {
                return ((URL)obj).toExternalForm();
            }
            if (obj instanceof URL[]) {
                URL[] array = (URL[])obj;
                return Util.convertTypedArrayToString(array, new StringConverter<URL>(){

                    @Override
                    public String convertObjectToString(URL toConvert) {
                        return toConvert.toExternalForm();
                    }
                });
            }
            if (obj instanceof URI) {
                try {
                    return ((URI)obj).toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    LOGGER.error("URI could not be transformed to URL", (Throwable)e);
                    return obj.toString();
                }
            }
            if (obj instanceof URI[]) {
                URI[] array = (URI[])obj;
                return Util.convertTypedArrayToString(array, new StringConverter<URI>(){

                    @Override
                    public String convertObjectToString(URI toConvert) {
                        try {
                            return toConvert.toURL().toExternalForm();
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error("URI could not be transformed to URL", (Throwable)e);
                            return toConvert.toString();
                        }
                    }
                });
            }
            if (obj == null) {
                return "null";
            }
            return obj.toString();
        }
    }

    private static <Type> String convertTypedArrayToString(Type[] array, StringConverter<Type> converter) {
        m_sb.delete(0, m_sb.length());
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                m_sb.append(", ");
            }
            m_sb.append(converter.convertObjectToString(array[i]));
        }
        return m_sb.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        StartLevel sl;
        ServiceReference ref = bundleContext.getServiceReference(StartLevel.class.getName());
        if (ref != null && (sl = (StartLevel)bundleContext.getService(ref)) != null) {
            int level = sl.getBundleStartLevel(bundle);
            int sbsl = 49;
            String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
            if (sbslProp != null) {
                try {
                    sbsl = Integer.valueOf(sbslProp);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return level <= sbsl;
        }
        return false;
    }

    public static boolean accessToSystemBundleIsAllowed(long bundleId, CommandSession session) throws IOException {
        String str;
        do {
            StringBuffer sb = new StringBuffer();
            System.err.print("You are about to access system bundle " + bundleId + ".  Do you wish to continue (yes/no): ");
            System.err.flush();
            while (true) {
                int c;
                if ((c = session.getKeyboard().read()) < 0) {
                    return false;
                }
                if (c == 13 || c == 10) break;
                System.err.print((char)c);
                System.err.flush();
                sb.append((char)c);
            }
            System.err.println();
            System.err.flush();
            str = sb.toString();
            if (!"yes".equals(str)) continue;
            return true;
        } while (!"no".equals(str));
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StringConverter<Type> {
        public String convertObjectToString(Type var1);
    }
}

