/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceKeyPairProvider
extends AbstractKeyPairProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader cloader;
    private String[] resources;
    private PasswordFinder passwordFinder;

    public ResourceKeyPairProvider() {
        this.cloader = this.getClass().getClassLoader();
    }

    public ResourceKeyPairProvider(String[] resources) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder) {
        this.cloader = this.getClass().getClassLoader();
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public ResourceKeyPairProvider(String[] resources, PasswordFinder passwordFinder, ClassLoader cloader) {
        this.cloader = cloader;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyPair[] loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.resources.length);
        String[] arr$ = this.resources;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block8: {
                Object var11_11;
                if (i$ >= len$) {
                    return keys.toArray(new KeyPair[keys.size()]);
                }
                String resource = arr$[i$];
                PEMReader r = null;
                InputStreamReader isr = null;
                InputStream is = null;
                try {
                    block7: {
                        try {
                            is = this.cloader.getResourceAsStream(resource);
                            isr = new InputStreamReader(is);
                            r = new PEMReader((Reader)isr, this.passwordFinder);
                            Object o = r.readObject();
                            if (!(o instanceof KeyPair)) break block7;
                            keys.add((KeyPair)o);
                        }
                        catch (Exception e) {
                            this.log.warn("Unable to read key", (Throwable)e);
                            var11_11 = null;
                            IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                            break block8;
                        }
                    }
                    var11_11 = null;
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    IoUtils.closeQuietly(new Closeable[]{r, is, isr});
                    throw throwable;
                }
                IoUtils.closeQuietly(new Closeable[]{r, is, isr});
            }
            ++i$;
        }
    }
}

