/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.fusesource.fabric.fab.osgi.FabResolverFactory;
import org.fusesource.fabric.fab.osgi.internal.FabConnection;
import org.fusesource.fabric.fab.osgi.internal.ServiceProvider;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabURLHandler
extends AbstractURLStreamHandlerService {
    private static String SYNTAX = "fab: fab-jar-uri";
    private static final Logger logger = LoggerFactory.getLogger(FabURLHandler.class);
    private ServiceProvider serviceProvider;
    private FabResolverFactory fabResolverFactory;

    public FabConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        URL fabJarURL = new URL(url.getPath());
        logger.debug("FAB jar URL is: [" + fabJarURL + "]");
        return new FabConnection(fabJarURL, this.fabResolverFactory, this.serviceProvider);
    }

    public void setFabResolverFactory(FabResolverFactory fabResolverFactory) {
        this.fabResolverFactory = fabResolverFactory;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }
}

