/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.restart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartRequest;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartResponse;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesRestartAction
extends TransportNodesOperationAction<NodesRestartRequest, NodesRestartResponse, NodeRestartRequest, NodesRestartResponse.NodeRestartResponse> {
    private final Node node;
    private final boolean disabled;
    private AtomicBoolean restartRequested = new AtomicBoolean();

    @Inject
    public TransportNodesRestartAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, Node node) {
        super(settings, clusterName, threadPool, clusterService, transportService);
        this.node = node;
        this.disabled = this.componentSettings.getAsBoolean("disabled", false);
    }

    @Override
    protected void doExecute(NodesRestartRequest nodesRestartRequest, ActionListener<NodesRestartResponse> listener) {
        listener.onFailure(new ElasticSearchIllegalStateException("restart is disabled (for now) ...."));
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "cluster/nodes/restart";
    }

    @Override
    protected NodesRestartResponse newResponse(NodesRestartRequest nodesShutdownRequest, AtomicReferenceArray responses) {
        ArrayList<NodesRestartResponse.NodeRestartResponse> nodeRestartResponses = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodesRestartResponse.NodeRestartResponse)) continue;
            nodeRestartResponses.add((NodesRestartResponse.NodeRestartResponse)resp);
        }
        return new NodesRestartResponse(this.clusterName, nodeRestartResponses.toArray(new NodesRestartResponse.NodeRestartResponse[nodeRestartResponses.size()]));
    }

    @Override
    protected NodesRestartRequest newRequest() {
        return new NodesRestartRequest();
    }

    @Override
    protected NodeRestartRequest newNodeRequest() {
        return new NodeRestartRequest();
    }

    @Override
    protected NodeRestartRequest newNodeRequest(String nodeId, NodesRestartRequest request) {
        return new NodeRestartRequest(nodeId, request.delay);
    }

    @Override
    protected NodesRestartResponse.NodeRestartResponse newNodeResponse() {
        return new NodesRestartResponse.NodeRestartResponse();
    }

    @Override
    protected NodesRestartResponse.NodeRestartResponse nodeOperation(NodeRestartRequest request) throws ElasticSearchException {
        if (this.disabled) {
            throw new ElasticSearchIllegalStateException("Restart is disabled");
        }
        if (!this.restartRequested.compareAndSet(false, true)) {
            return new NodesRestartResponse.NodeRestartResponse(this.clusterService.state().nodes().localNode());
        }
        this.logger.info("Restarting in [{}]", request.delay);
        this.threadPool.schedule(request.delay, "generic", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean restartWithWrapper = false;
                if (System.getProperty("elasticsearch-service") != null) {
                    try {
                        Class<?> wrapperManager = TransportNodesRestartAction.this.settings.getClassLoader().loadClass("org.tanukisoftware.wrapper.WrapperManager");
                        TransportNodesRestartAction.this.logger.info("Initiating requested restart (using service)", new Object[0]);
                        wrapperManager.getMethod("restartAndReturn", new Class[0]).invoke(null, new Object[0]);
                        restartWithWrapper = true;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (!restartWithWrapper) {
                    TransportNodesRestartAction.this.logger.info("Initiating requested restart", new Object[0]);
                    try {
                        TransportNodesRestartAction.this.node.stop();
                        TransportNodesRestartAction.this.node.start();
                    }
                    catch (Exception e) {
                        TransportNodesRestartAction.this.logger.warn("Failed to restart", e, new Object[0]);
                    }
                    finally {
                        TransportNodesRestartAction.this.restartRequested.set(false);
                    }
                }
            }
        });
        return new NodesRestartResponse.NodeRestartResponse(this.clusterService.state().nodes().localNode());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    protected static class NodeRestartRequest
    extends NodeOperationRequest {
        TimeValue delay;

        private NodeRestartRequest() {
        }

        private NodeRestartRequest(String nodeId, TimeValue delay) {
            super(nodeId);
            this.delay = delay;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.delay = TimeValue.readTimeValue(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.delay.writeTo(out);
        }
    }
}

