/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiGetRequest
implements ActionRequest {
    private boolean listenerThreaded = false;
    String preference;
    Boolean realtime;
    boolean refresh;
    List<Item> items = new ArrayList<Item>();

    public MultiGetRequest add(Item item) {
        this.items.add(item);
        return this;
    }

    public MultiGetRequest add(String index, @Nullable String type, String id) {
        this.items.add(new Item(index, type, id));
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    @Override
    public MultiGetRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.items.isEmpty()) {
            validationException = ValidateActions.addValidationError("no documents to get", validationException);
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                if (item.index() == null) {
                    validationException = ValidateActions.addValidationError("index is missing for doc " + i, validationException);
                }
                if (item.id() != null) continue;
                validationException = ValidateActions.addValidationError("id is missing for doc " + i, validationException);
            }
        }
        return validationException;
    }

    public MultiGetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, byte[] data, int from, int length) throws Exception {
        XContentParser parser = XContentFactory.xContent(data, from, length).createParser(data, from, length);
        try {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                if ("docs".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new ElasticSearchIllegalArgumentException("docs array element should include an object");
                        }
                        String index = defaultIndex;
                        String type = defaultType;
                        String id = null;
                        String routing = null;
                        ArrayList<String> fields = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if ("_index".equals(currentFieldName)) {
                                    index = parser.text();
                                    continue;
                                }
                                if ("_type".equals(currentFieldName)) {
                                    type = parser.text();
                                    continue;
                                }
                                if ("_id".equals(currentFieldName)) {
                                    id = parser.text();
                                    continue;
                                }
                                if (!"_routing".equals(currentFieldName) && !"routing".equals(currentFieldName)) continue;
                                routing = parser.text();
                                continue;
                            }
                            if (token != XContentParser.Token.START_ARRAY || !"fields".equals(currentFieldName)) continue;
                            fields = new ArrayList<String>();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                fields.add(parser.text());
                            }
                        }
                        String[] aFields = fields != null ? fields.toArray(new String[fields.size()]) : defaultFields;
                        this.add(new Item(index, type, id).routing(routing).fields(aFields));
                    }
                    continue;
                }
                if (!"ids".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new ElasticSearchIllegalArgumentException("ids array element should only contain ids");
                    }
                    this.add(new Item(defaultIndex, defaultType, parser.text()).fields(defaultFields));
                }
            }
        }
        finally {
            parser.close();
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.preference = in.readUTF();
        }
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
        int size = in.readVInt();
        this.items = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Item.readItem(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.preference == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.preference);
        }
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    public static class Item
    implements Streamable {
        private String index;
        private String type;
        private String id;
        private String routing;
        private String[] fields;

        Item() {
        }

        public Item(String index, @Nullable String type, String id) {
            this.index = index;
            this.type = type;
            this.id = id;
        }

        public String index() {
            return this.index;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public String[] fields() {
            return this.fields;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int size;
            this.index = in.readUTF();
            if (in.readBoolean()) {
                this.type = in.readUTF();
            }
            this.id = in.readUTF();
            if (in.readBoolean()) {
                this.routing = in.readUTF();
            }
            if ((size = in.readVInt()) > 0) {
                this.fields = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.fields[i] = in.readUTF();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.index);
            if (this.type == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.type);
            }
            out.writeUTF(this.id);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.routing);
            }
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.length);
                for (String field : this.fields) {
                    out.writeUTF(field);
                }
            }
        }
    }
}

