/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.controller.ShardDoc;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchScrollQueryThenFetchAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;
    private final TransportSearchCache searchCache;

    @Inject
    public TransportSearchScrollQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache searchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.searchCache = searchCache;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        protected volatile LinkedTransferQueue<ShardSearchFailure> shardFailures;
        private final Map<SearchShardTarget, QuerySearchResultProvider> queryResults;
        private final Map<SearchShardTarget, FetchSearchResult> fetchResults;
        private volatile ShardDoc[] sortedShardList;
        private final AtomicInteger successfulOps;
        private final long startTime;

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.queryResults = TransportSearchScrollQueryThenFetchAction.this.searchCache.obtainQueryResults();
            this.fetchResults = TransportSearchScrollQueryThenFetchAction.this.searchCache.obtainFetchResults();
            this.startTime = System.currentTimeMillis();
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollQueryThenFetchAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.context().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            LinkedTransferQueue<ShardSearchFailure> localFailures = this.shardFailures;
            if (localFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            return localFailures.toArray(ShardSearchFailure.EMPTY_ARRAY);
        }

        protected final void addShardFailure(ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new LinkedTransferQueue();
            }
            this.shardFailures.add(failure);
        }

        public void start() {
            if (this.scrollId.context().length == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", null));
                return;
            }
            final AtomicInteger counter = new AtomicInteger(this.scrollId.context().length);
            int localOperations = 0;
            for (Tuple<String, Long> target : this.scrollId.context()) {
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    if (this.nodes.localNodeId().equals(node.id())) {
                        ++localOperations;
                        continue;
                    }
                    this.executeQueryPhase(counter, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryThenFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.source() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (counter.decrementAndGet() != 0) continue;
                this.executeFetchPhase();
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchScrollQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Tuple<String, Long> target : AsyncAction.this.scrollId.context()) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(target.v1());
                                if (node == null || !AsyncAction.this.nodes.localNodeId().equals(node.id())) continue;
                                AsyncAction.this.executeQueryPhase(counter, node, target.v2());
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final Tuple<String, Long> target : this.scrollId.context()) {
                        final DiscoveryNode node = this.nodes.get(target.v1());
                        if (node == null || !this.nodes.localNodeId().equals(node.id())) continue;
                        if (localAsync) {
                            TransportSearchScrollQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executeQueryPhase(counter, node, (Long)target.v2());
                                }
                            });
                            continue;
                        }
                        this.executeQueryPhase(counter, node, target.v2());
                    }
                }
            }
        }

        private void executeQueryPhase(final AtomicInteger counter, DiscoveryNode node, final long searchId) {
            TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteQuery(node, TransportSearchHelper.internalScrollSearchRequest(searchId, this.request), new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result) {
                    AsyncAction.this.queryResults.put(result.shardTarget(), result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchScrollQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
                    }
                    AsyncAction.this.addShardFailure(new ShardSearchFailure(t));
                    AsyncAction.this.successfulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }
            });
        }

        private void executeFetchPhase() {
            this.sortedShardList = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults.values());
            Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.docIdsToLoad(this.sortedShardList);
            if (docIdsToLoad.isEmpty()) {
                this.finishHim();
            }
            final AtomicInteger counter = new AtomicInteger(docIdsToLoad.size());
            for (final Map.Entry<SearchShardTarget, ExtTIntArrayList> entry : docIdsToLoad.entrySet()) {
                SearchShardTarget shardTarget = entry.getKey();
                ExtTIntArrayList docIds = entry.getValue();
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.queryResults.get(shardTarget).id(), docIds);
                DiscoveryNode node = this.nodes.get(shardTarget.nodeId());
                TransportSearchScrollQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                    @Override
                    public void onResult(FetchSearchResult result) {
                        result.shardTarget((SearchShardTarget)entry.getKey());
                        AsyncAction.this.fetchResults.put(result.shardTarget(), result);
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        if (TransportSearchScrollQueryThenFetchAction.this.logger.isDebugEnabled()) {
                            TransportSearchScrollQueryThenFetchAction.this.logger.debug("Failed to execute fetch phase", t, new Object[0]);
                        }
                        AsyncAction.this.successfulOps.decrementAndGet();
                        if (counter.decrementAndGet() == 0) {
                            AsyncAction.this.finishHim();
                        }
                    }
                });
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Exception e) {
                this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
            }
        }

        private void innerFinishHim() {
            InternalSearchResponse internalResponse = TransportSearchScrollQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.context().length, this.successfulOps.get(), System.currentTimeMillis() - this.startTime, this.buildShardFailures()));
            TransportSearchScrollQueryThenFetchAction.this.searchCache.releaseQueryResults(this.queryResults);
            TransportSearchScrollQueryThenFetchAction.this.searchCache.releaseFetchResults(this.fetchResults);
        }
    }
}

