/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class UpdateRequest
extends InstanceShardOperationRequest {
    private String type;
    private String id;
    @Nullable
    private String routing;
    String script;
    @Nullable
    String scriptLang;
    @Nullable
    Map<String, Object> scriptParams;
    int retryOnConflict = 0;
    private String percolate;
    private boolean refresh = false;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;

    UpdateRequest() {
    }

    public UpdateRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.script == null) {
            validationException = ValidateActions.addValidationError("script is missing", validationException);
        }
        return validationException;
    }

    public UpdateRequest index(String index) {
        this.index = index;
        return this;
    }

    public String type() {
        return this.type;
    }

    public UpdateRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public UpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    public UpdateRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    public UpdateRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public String routing() {
        return this.routing;
    }

    int shardId() {
        return this.shardId;
    }

    public UpdateRequest script(String script) {
        this.script = script;
        return this;
    }

    public UpdateRequest scriptLang(String scriptLang) {
        this.scriptLang = scriptLang;
        return this;
    }

    public UpdateRequest addScriptParam(String name, Object value) {
        if (this.scriptParams == null) {
            this.scriptParams = Maps.newHashMap();
        }
        this.scriptParams.put(name, value);
        return this;
    }

    public UpdateRequest scriptParams(Map<String, Object> scriptParams) {
        if (this.scriptParams == null) {
            this.scriptParams = scriptParams;
        } else {
            this.scriptParams.putAll(scriptParams);
        }
        return this;
    }

    public UpdateRequest script(String script, @Nullable Map<String, Object> scriptParams) {
        this.script = script;
        if (this.scriptParams != null) {
            this.scriptParams.putAll(scriptParams);
        } else {
            this.scriptParams = scriptParams;
        }
        return this;
    }

    public UpdateRequest script(String script, @Nullable String scriptLang, @Nullable Map<String, Object> scriptParams) {
        this.script = script;
        this.scriptLang = scriptLang;
        if (this.scriptParams != null) {
            this.scriptParams.putAll(scriptParams);
        } else {
            this.scriptParams = scriptParams;
        }
        return this;
    }

    public UpdateRequest retryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    public UpdateRequest percolate(String percolate) {
        this.percolate = percolate;
        return this;
    }

    public String percolate() {
        return this.percolate;
    }

    public UpdateRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public UpdateRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    public UpdateRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public UpdateRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public UpdateRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        this.script = in.readUTF();
        if (in.readBoolean()) {
            this.scriptLang = in.readUTF();
        }
        this.scriptParams = in.readMap();
        this.retryOnConflict = in.readVInt();
        if (in.readBoolean()) {
            this.percolate = in.readUTF();
        }
        this.refresh = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        out.writeUTF(this.type);
        out.writeUTF(this.id);
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        out.writeUTF(this.script);
        if (this.scriptLang == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.scriptLang);
        }
        out.writeMap(this.scriptParams);
        out.writeVInt(this.retryOnConflict);
        if (this.percolate == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.percolate);
        }
        out.writeBoolean(this.refresh);
    }
}

