/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Set;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.DisableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class AllocationDeciders
extends AllocationDecider {
    private final AllocationDecider[] allocations;

    public AllocationDeciders(Settings settings, NodeSettingsService nodeSettingsService) {
        this(settings, (Set<AllocationDecider>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new SameShardAllocationDecider(settings))).add(new FilterAllocationDecider(settings, nodeSettingsService))).add(new ReplicaAfterPrimaryActiveAllocationDecider(settings))).add(new ThrottlingAllocationDecider(settings, nodeSettingsService))).add(new RebalanceOnlyWhenActiveAllocationDecider(settings))).add(new ClusterRebalanceAllocationDecider(settings))).add(new ConcurrentRebalanceAllocationDecider(settings, nodeSettingsService))).add(new DisableAllocationDecider(settings, nodeSettingsService))).add(new AwarenessAllocationDecider(settings, nodeSettingsService))).add(new ShardsLimitAllocationDecider(settings))).build()));
    }

    @Inject
    public AllocationDeciders(Settings settings, Set<AllocationDecider> allocations) {
        super(settings);
        this.allocations = allocations.toArray(new AllocationDecider[allocations.size()]);
    }

    @Override
    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        for (AllocationDecider allocation1 : this.allocations) {
            if (allocation1.canRebalance(shardRouting, allocation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AllocationDecider.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        AllocationDecider.Decision ret = AllocationDecider.Decision.YES;
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return AllocationDecider.Decision.NO;
        }
        for (AllocationDecider allocation1 : this.allocations) {
            AllocationDecider.Decision decision = allocation1.canAllocate(shardRouting, node, allocation);
            if (decision == AllocationDecider.Decision.NO) {
                return AllocationDecider.Decision.NO;
            }
            if (decision != AllocationDecider.Decision.THROTTLE) continue;
            ret = AllocationDecider.Decision.THROTTLE;
        }
        return ret;
    }

    @Override
    public boolean canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return false;
        }
        for (AllocationDecider allocation1 : this.allocations) {
            if (allocation1.canRemain(shardRouting, node, allocation)) continue;
            return false;
        }
        return true;
    }
}

