/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String INDEX_TOTAL_SHARDS_PER_NODE = "index.routing.allocation.total_shards_per_node";

    @Inject
    public ShardsLimitAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public AllocationDecider.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        int totalShardsPerNode = indexMd.settings().getAsInt(INDEX_TOTAL_SHARDS_PER_NODE, -1);
        if (totalShardsPerNode <= 0) {
            return AllocationDecider.Decision.YES;
        }
        int nodeCount = 0;
        List<MutableShardRouting> shards = node.shards();
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting nodeShard = shards.get(i);
            if (!nodeShard.index().equals(shardRouting.index()) || nodeShard.relocating()) continue;
            ++nodeCount;
        }
        if (nodeCount >= totalShardsPerNode) {
            return AllocationDecider.Decision.NO;
        }
        return AllocationDecider.Decision.YES;
    }

    @Override
    public boolean canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        int totalShardsPerNode = indexMd.settings().getAsInt(INDEX_TOTAL_SHARDS_PER_NODE, -1);
        if (totalShardsPerNode <= 0) {
            return true;
        }
        int nodeCount = 0;
        List<MutableShardRouting> shards = node.shards();
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting nodeShard = shards.get(i);
            if (!nodeShard.index().equals(shardRouting.index()) || nodeShard.relocating()) continue;
            ++nodeCount;
        }
        return nodeCount <= totalShardsPerNode;
    }

    static {
        IndexMetaData.addDynamicSettings(INDEX_TOTAL_SHARDS_PER_NODE);
    }
}

