/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Arrays;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.thread.ThreadLocals;

public class Unicode {
    private static ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>> cachedUtf8Result = new ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>>(){

        @Override
        protected ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result> initialValue() {
            return new ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>(new UnicodeUtil.UTF8Result());
        }
    };
    private static ThreadLocal<ThreadLocals.CleanableValue<UTF16Result>> cachedUtf16Result = new ThreadLocal<ThreadLocals.CleanableValue<UTF16Result>>(){

        @Override
        protected ThreadLocals.CleanableValue<UTF16Result> initialValue() {
            return new ThreadLocals.CleanableValue<UTF16Result>(new UTF16Result());
        }
    };
    private static final long UNI_MAX_BMP = 65535L;
    private static final int HALF_BASE = 65536;
    private static final long HALF_SHIFT = 10L;
    private static final long HALF_MASK = 1023L;

    public static byte[] fromStringAsBytes(String source) {
        if (source == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result = Unicode.unsafeFromStringAsUtf8(source);
        return Arrays.copyOfRange(result.result, 0, result.length);
    }

    public static UnicodeUtil.UTF8Result fromStringAsUtf8(String source) {
        if (source == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(source, 0, source.length(), result);
        return result;
    }

    public static UnicodeUtil.UTF8Result unsafeFromStringAsUtf8(String source) {
        if (source == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result = cachedUtf8Result.get().get();
        UnicodeUtil.UTF16toUTF8(source, 0, source.length(), result);
        return result;
    }

    public static String fromBytes(byte[] source) {
        return Unicode.fromBytes(source, 0, source.length);
    }

    public static String fromBytes(byte[] source, int offset, int length) {
        if (source == null) {
            return null;
        }
        UTF16Result result = Unicode.unsafeFromBytesAsUtf16(source, offset, length);
        return new String(result.result, 0, result.length);
    }

    public static UTF16Result fromBytesAsUtf16(byte[] source) {
        return Unicode.fromBytesAsUtf16(source, 0, source.length);
    }

    public static UTF16Result fromBytesAsUtf16(byte[] source, int offset, int length) {
        if (source == null) {
            return null;
        }
        UTF16Result result = new UTF16Result();
        Unicode.UTF8toUTF16(source, offset, length, result);
        return result;
    }

    public static UTF16Result unsafeFromBytesAsUtf16(byte[] source) {
        return Unicode.unsafeFromBytesAsUtf16(source, 0, source.length);
    }

    public static UTF16Result unsafeFromBytesAsUtf16(byte[] source, int offset, int length) {
        if (source == null) {
            return null;
        }
        UTF16Result result = cachedUtf16Result.get().get();
        Unicode.UTF8toUTF16(source, offset, length, result);
        return result;
    }

    public static void UTF8toUTF16(byte[] utf8, int offset, int length, UTF16Result result) {
        int end = offset + length;
        char[] out = result.result;
        int upto = offset;
        int outUpto = 0;
        if (outUpto + length >= out.length) {
            char[] newOut = new char[2 * (outUpto + length)];
            System.arraycopy(out, 0, newOut, 0, outUpto);
            out = newOut;
            result.result = newOut;
        }
        while (upto < end) {
            int ch;
            int b = utf8[upto] & 0xFF;
            ++upto;
            if (b < 192) {
                assert (b < 128);
                ch = b;
            } else if (b < 224) {
                ch = ((b & 0x1F) << 6) + (utf8[upto] & 0x3F);
                ++upto;
            } else if (b < 240) {
                ch = ((b & 0xF) << 12) + ((utf8[upto] & 0x3F) << 6) + (utf8[upto + 1] & 0x3F);
                upto += 2;
            } else {
                assert (b < 248);
                ch = ((b & 7) << 18) + ((utf8[upto] & 0x3F) << 12) + ((utf8[upto + 1] & 0x3F) << 6) + (utf8[upto + 2] & 0x3F);
                upto += 3;
            }
            if ((long)ch <= 65535L) {
                out[outUpto++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[outUpto++] = (char)((chHalf >> 10) + 55296);
            out[outUpto++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        result.length = outUpto;
    }

    public static final class UTF16Result {
        public char[] result = new char[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                char[] newArray = new char[(int)(1.5 * (double)newLength)];
                System.arraycopy(this.result, 0, newArray, 0, this.length);
                this.result = newArray;
            }
            this.length = newLength;
        }

        public void copyText(UTF16Result other) {
            this.setLength(other.length);
            System.arraycopy(other.result, 0, this.result, 0, this.length);
        }
    }
}

