/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.hdfs;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.hdfs.HdfsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;

public abstract class AbstractHdfsBlobContainer
extends AbstractBlobContainer {
    protected final HdfsBlobStore blobStore;
    protected final Path path;

    public AbstractHdfsBlobContainer(HdfsBlobStore blobStore, BlobPath blobPath, Path path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        FileStatus[] files = this.blobStore.fileSystem().listStatus(this.path);
        if (files == null || files.length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, PlainBlobMetaData> builder = ImmutableMap.builder();
        for (FileStatus file : files) {
            builder.put(file.getPath().getName(), new PlainBlobMetaData(file.getPath().getName(), file.getLen()));
        }
        return builder.build();
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(final String blobNamePrefix) throws IOException {
        FileStatus[] files = this.blobStore.fileSystem().listStatus(this.path, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(blobNamePrefix);
            }
        });
        if (files == null || files.length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, PlainBlobMetaData> builder = ImmutableMap.builder();
        for (FileStatus file : files) {
            builder.put(file.getPath().getName(), new PlainBlobMetaData(file.getPath().getName(), file.getLen()));
        }
        return builder.build();
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        return this.blobStore.fileSystem().delete(new Path(this.path, blobName), true);
    }

    @Override
    public boolean blobExists(String blobName) {
        try {
            return this.blobStore.fileSystem().exists(new Path(this.path, blobName));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void readBlob(final String blobName, final BlobContainer.ReadBlobListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            @Override
            public void run() {
                FSDataInputStream fileStream;
                byte[] buffer = new byte[AbstractHdfsBlobContainer.this.blobStore.bufferSizeInBytes()];
                try {
                    fileStream = AbstractHdfsBlobContainer.this.blobStore.fileSystem().open(new Path(AbstractHdfsBlobContainer.this.path, blobName));
                }
                catch (IOException e) {
                    listener.onFailure(e);
                    return;
                }
                try {
                    int bytesRead;
                    while ((bytesRead = fileStream.read(buffer)) != -1) {
                        listener.onPartial(buffer, 0, bytesRead);
                    }
                    listener.onCompleted();
                }
                catch (Exception e) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    listener.onFailure(e);
                }
            }
        });
    }
}

