/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class BoundedTreeSet<E>
extends TreeSet<E> {
    private final int size;

    public BoundedTreeSet(int size) {
        this.size = size;
    }

    public BoundedTreeSet(Comparator<? super E> comparator, int size) {
        super(comparator);
        this.size = size;
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.rebound();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = super.addAll(c);
        this.rebound();
        return result;
    }

    private void rebound() {
        while (this.size() > this.size) {
            this.remove(this.last());
        }
    }
}

