/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BytesStreamOutput
extends StreamOutput
implements BytesStream {
    protected byte[] buf;
    protected int count;

    public BytesStreamOutput() {
        this(126);
    }

    public BytesStreamOutput(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void writeByte(byte b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = b;
        this.count = newcount;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, offset, this.buf, this.count, length);
        this.count = newcount;
    }

    public void seek(int seekTo) {
        this.count = seekTo;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte[] copiedByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    public byte[] underlyingBytes() {
        return this.buf;
    }

    @Override
    public int size() {
        return this.count;
    }
}

