/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Closeables;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.local.state.meta.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;

public class LocalGatewayMetaState
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private volatile MetaData currentMetaData;
    private final XContentType format;
    private final ToXContent.Params formatParams;

    @Inject
    public LocalGatewayMetaState(Settings settings, NodeEnvironment nodeEnv, TransportNodesListGatewayMetaState nodesListGatewayMetaState) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.format = XContentType.fromRestContentType(settings.get("format", "smile"));
        nodesListGatewayMetaState.init(this);
        if (this.format == XContentType.SMILE) {
            HashMap<String, String> params = Maps.newHashMap();
            params.put("binary", "true");
            this.formatParams = new ToXContent.MapParams(params);
        } else {
            this.formatParams = ToXContent.EMPTY_PARAMS;
        }
        if (DiscoveryNode.masterNode(settings)) {
            try {
                this.pre019Upgrade();
                long start = System.currentTimeMillis();
                this.loadState();
                this.logger.debug("took {} to load state", TimeValue.timeValueMillis(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state, exiting...", e, new Object[0]);
                throw e;
            }
        }
    }

    public MetaData currentMetaData() {
        return this.currentMetaData;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (!event.state().nodes().localNode().masterNode()) {
            return;
        }
        if (!event.metaDataChanged()) {
            return;
        }
        boolean success = true;
        if (this.currentMetaData == null || !MetaData.isGlobalStateEquals(this.currentMetaData, event.state().metaData())) {
            try {
                this.writeGlobalState("changed", event.state().metaData(), this.currentMetaData);
            }
            catch (Exception e) {
                success = false;
            }
        }
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            IndexMetaData currentIndexMetaData;
            String writeReason = null;
            IndexMetaData indexMetaData2 = currentIndexMetaData = this.currentMetaData == null ? null : this.currentMetaData.index(indexMetaData.index());
            if (currentIndexMetaData == null) {
                writeReason = "freshly created";
            } else if (currentIndexMetaData.version() != indexMetaData.version()) {
                writeReason = "version changed from [" + currentIndexMetaData.version() + "] to [" + indexMetaData.version() + "]";
            }
            if (writeReason == null) continue;
            try {
                this.writeIndex(writeReason, indexMetaData, currentIndexMetaData);
            }
            catch (Exception e) {
                success = false;
            }
        }
        if (this.currentMetaData != null) {
            for (IndexMetaData current : this.currentMetaData) {
                if (event.state().metaData().index(current.index()) != null) continue;
                this.deleteIndex(current.index());
            }
        }
        if (success) {
            this.currentMetaData = event.state().metaData();
        }
    }

    private void deleteIndex(String index) {
        File[] indexLocations;
        this.logger.trace("[{}] delete index state", index);
        for (File indexLocation : indexLocations = this.nodeEnv.indexLocations(new Index(index))) {
            if (!indexLocation.exists()) continue;
            FileSystemUtils.deleteRecursively(new File(indexLocation, "_state"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(String reason, IndexMetaData indexMetaData, @Nullable IndexMetaData previousIndexMetaData) throws Exception {
        this.logger.trace("[{}] writing state, reason [{}]", indexMetaData.index(), reason);
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.format, cachedEntry.cachedBytes());
            builder.startObject();
            IndexMetaData.Builder.toXContent(indexMetaData, builder, this.formatParams);
            builder.endObject();
            builder.flush();
            Exception lastFailure = null;
            boolean wroteAtLeastOnce = false;
            for (File indexLocation : this.nodeEnv.indexLocations(new Index(indexMetaData.index()))) {
                File stateLocation = new File(indexLocation, "_state");
                FileSystemUtils.mkdirs(stateLocation);
                File stateFile = new File(stateLocation, "state-" + indexMetaData.version());
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(stateFile);
                    fos.write(cachedEntry.bytes().underlyingBytes(), 0, cachedEntry.bytes().size());
                    fos.getChannel().force(true);
                    Closeables.closeQuietly(fos);
                    wroteAtLeastOnce = true;
                }
                catch (Exception e) {
                    try {
                        lastFailure = e;
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(fos);
                        throw throwable;
                    }
                    Closeables.closeQuietly(fos);
                    continue;
                }
                Closeables.closeQuietly(fos);
            }
            if (!wroteAtLeastOnce) {
                this.logger.warn("[{}]: failed to state", lastFailure, indexMetaData.index());
                throw new IOException("failed to write state for [" + indexMetaData.index() + "]", lastFailure);
            }
            if (previousIndexMetaData != null && previousIndexMetaData.version() != indexMetaData.version()) {
                for (File indexLocation : this.nodeEnv.indexLocations(new Index(indexMetaData.index()))) {
                    File stateFile = new File(new File(indexLocation, "_state"), "state-" + previousIndexMetaData.version());
                    stateFile.delete();
                }
            }
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGlobalState(String reason, MetaData metaData, @Nullable MetaData previousMetaData) throws Exception {
        this.logger.trace("[_global] writing state, reason [{}]", reason);
        MetaData globalMetaData = MetaData.builder().metaData(metaData).removeAllIndices().build();
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.format, cachedEntry.cachedBytes());
            builder.startObject();
            MetaData.Builder.toXContent(globalMetaData, builder, this.formatParams);
            builder.endObject();
            builder.flush();
            Exception lastFailure = null;
            boolean wroteAtLeastOnce = false;
            for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
                File stateLocation = new File(dataLocation, "_state");
                FileSystemUtils.mkdirs(stateLocation);
                File stateFile = new File(stateLocation, "global-" + globalMetaData.version());
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(stateFile);
                    fos.write(cachedEntry.bytes().underlyingBytes(), 0, cachedEntry.bytes().size());
                    fos.getChannel().force(true);
                    Closeables.closeQuietly(fos);
                    wroteAtLeastOnce = true;
                }
                catch (Exception e) {
                    try {
                        lastFailure = e;
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(fos);
                        throw throwable;
                    }
                    Closeables.closeQuietly(fos);
                    continue;
                }
                Closeables.closeQuietly(fos);
            }
            if (!wroteAtLeastOnce) {
                this.logger.warn("[_global]: failed to write global state", lastFailure, new Object[0]);
                throw new IOException("failed to write global state", lastFailure);
            }
            if (previousMetaData != null && previousMetaData.version() != this.currentMetaData.version()) {
                for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
                    File stateFile = new File(new File(dataLocation, "_state"), "global-" + previousMetaData.version());
                    stateFile.delete();
                }
            }
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    private void loadState() throws Exception {
        MetaData.Builder metaDataBuilder = MetaData.builder();
        MetaData globalMetaData = this.loadGlobalState();
        if (globalMetaData != null) {
            metaDataBuilder.metaData(globalMetaData);
        }
        Set<String> indices = this.nodeEnv.findAllIndices();
        for (String index : indices) {
            IndexMetaData indexMetaData = this.loadIndex(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] failed to find metadata for existing index location", index);
                continue;
            }
            metaDataBuilder.put(indexMetaData, false);
        }
        this.currentMetaData = metaDataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexMetaData loadIndex(String index) {
        long highestVersion = -1L;
        IndexMetaData indexMetaData = null;
        for (File indexLocation : this.nodeEnv.indexLocations(new Index(index))) {
            File[] stateFiles;
            File stateDir = new File(indexLocation, "_state");
            if (!stateDir.exists() || !stateDir.isDirectory() || (stateFiles = stateDir.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                if (!stateFile.getName().startsWith("state-")) continue;
                try {
                    long version = Long.parseLong(stateFile.getName().substring("state-".length()));
                    if (version <= highestVersion) continue;
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[{}]: no data for [" + stateFile.getAbsolutePath() + "], ignoring...", index);
                        continue;
                    }
                    XContentParser parser = null;
                    try {
                        parser = XContentHelper.createParser(data, 0, data.length);
                        parser.nextToken();
                        indexMetaData = IndexMetaData.Builder.fromXContent(parser);
                        highestVersion = version;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.debug("[{}]: failed to read [" + stateFile.getAbsolutePath() + "], ignoring...", e, index);
                }
            }
        }
        return indexMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData loadGlobalState() {
        long highestVersion = -1L;
        MetaData metaData = null;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("global-")) continue;
                try {
                    long version = Long.parseLong(stateFile.getName().substring("global-".length()));
                    if (version <= highestVersion) continue;
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[_global] no data for [" + stateFile.getAbsolutePath() + "], ignoring...", new Object[0]);
                        continue;
                    }
                    XContentParser parser = null;
                    try {
                        parser = XContentHelper.createParser(data, 0, data.length);
                        metaData = MetaData.Builder.fromXContent(parser);
                        highestVersion = version;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.debug("", new Object[0]);
                }
            }
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pre019Upgrade() throws Exception {
        long index = -1L;
        File metaDataFile = null;
        MetaData metaData = null;
        long version = -1L;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                long fileIndex;
                String name;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[upgrade]: processing [" + stateFile.getName() + "]", new Object[0]);
                }
                if (!(name = stateFile.getName()).startsWith("metadata-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
                try {
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) continue;
                    XContentParser parser = XContentHelper.createParser(data, 0, data.length);
                    try {
                        String currentFieldName = null;
                        XContentParser.Token token = parser.nextToken();
                        if (token != null) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    continue;
                                }
                                if (token == XContentParser.Token.START_OBJECT) {
                                    if (!"meta-data".equals(currentFieldName)) continue;
                                    metaData = MetaData.Builder.fromXContent(parser);
                                    continue;
                                }
                                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                                version = parser.longValue();
                            }
                        }
                    }
                    finally {
                        parser.close();
                    }
                    index = fileIndex;
                    metaDataFile = stateFile;
                }
                catch (IOException e) {
                    this.logger.warn("failed to read pre 0.19 state from [" + name + "], ignoring...", e, new Object[0]);
                }
            }
        }
        if (metaData == null) {
            return;
        }
        this.logger.info("found old metadata state, loading metadata from [{}] and converting to new metadata location and strucutre...", metaDataFile.getAbsolutePath());
        this.writeGlobalState("upgrade", MetaData.builder().metaData(metaData).version(version).build(), null);
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData).version(version);
            indexMetaDataBuilder.settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put("index.version.created", Version.V_0_18_0));
            this.writeIndex("upgrade", indexMetaDataBuilder.build(), null);
        }
        File backupFile = new File(metaDataFile.getParentFile(), "backup-" + metaDataFile.getName());
        if (!metaDataFile.renameTo(backupFile)) {
            throw new IOException("failed to rename old state to backup state [" + metaDataFile.getAbsolutePath() + "]");
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File[] stateFiles;
            File stateLocation = new File(dataLocation, "_state");
            if (!stateLocation.exists() || (stateFiles = stateLocation.listFiles()) == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("metadata-")) continue;
                stateFile.delete();
            }
        }
        this.logger.info("conversion to new metadata location and format done, backup create at [{}]", backupFile.getAbsolutePath());
    }
}

