/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;

@MBean(objectName="service=http", description="Http")
public class HttpServerManagement {
    private final HttpServer httpServer;

    @Inject
    public HttpServerManagement(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @ManagedAttribute(description="Transport address published to other nodes")
    public String getPublishAddress() {
        return this.httpServer.info().address().publishAddress().toString();
    }

    @ManagedAttribute(description="Transport address bounded on")
    public String getBoundAddress() {
        return this.httpServer.info().address().boundAddress().toString();
    }

    @ManagedAttribute(description="Total open")
    public long getTotalOpen() {
        return this.httpServer.stats().totalOpen();
    }

    @ManagedAttribute(description="Server open")
    public long getServerOpen() {
        return this.httpServer.stats().serverOpen();
    }
}

