/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class FQueryFilterParser
implements FilterParser {
    public static final String NAME = "fquery";

    @Inject
    public FQueryFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[fquery] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[fquery] filter does not support [" + currentFieldName + "]");
        }
        Filter filter = new QueryWrapperFilter(query);
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

