/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.TextQueryParser;

public class TextQueryParser
implements QueryParser {
    public static final String NAME = "text";

    @Inject
    public TextQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "text_phrase", "textPhrase", "text_phrase_prefix", "textPhrasePrefix", "fuzzyText", "fuzzy_text"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        TextQueryParser.Type type = TextQueryParser.Type.BOOLEAN;
        if ("text_phrase".equals(parser.currentName()) || "textPhrase".equals(parser.currentName())) {
            type = TextQueryParser.Type.PHRASE;
        } else if ("text_phrase_prefix".equals(parser.currentName()) || "textPhrasePrefix".equals(parser.currentName())) {
            type = TextQueryParser.Type.PHRASE_PREFIX;
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[text] query malformed, no field");
        }
        String fieldName = parser.currentName();
        String text = null;
        float boost = 1.0f;
        int phraseSlop = 0;
        String analyzer = null;
        String fuzziness = null;
        int prefixLength = 0;
        int maxExpansions = Integer.MAX_VALUE;
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    text = parser.text();
                    continue;
                }
                if ("type".equals(currentFieldName)) {
                    String tStr = parser.text();
                    if ("boolean".equals(tStr)) {
                        type = TextQueryParser.Type.BOOLEAN;
                        continue;
                    }
                    if ("phrase".equals(tStr)) {
                        type = TextQueryParser.Type.PHRASE;
                        continue;
                    }
                    if (!"phrase_prefix".equals(tStr) && !"phrasePrefix".equals(currentFieldName)) continue;
                    type = TextQueryParser.Type.PHRASE_PREFIX;
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parser.text();
                    if (parseContext.analysisService().analyzer(analyzer) != null) continue;
                    throw new QueryParsingException(parseContext.index(), "[text] analyzer [" + parser.text() + "] not found");
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("slop".equals(currentFieldName) || "phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                    phraseSlop = parser.intValue();
                    continue;
                }
                if ("fuzziness".equals(currentFieldName)) {
                    fuzziness = parser.textOrNull();
                    continue;
                }
                if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                    prefixLength = parser.intValue();
                    continue;
                }
                if ("max_expansions".equals(currentFieldName) || "maxExpansions".equals(currentFieldName)) {
                    maxExpansions = parser.intValue();
                    continue;
                }
                if ("operator".equals(currentFieldName)) {
                    String op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        occur = BooleanClause.Occur.SHOULD;
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        occur = BooleanClause.Occur.MUST;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "text query requires operator to be either 'and' or 'or', not [" + op + "]");
                }
                throw new QueryParsingException(parseContext.index(), "[text] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            text = parser.text();
            parser.nextToken();
        }
        if (text == null) {
            throw new QueryParsingException(parseContext.index(), "No text specified for text query");
        }
        org.elasticsearch.index.search.TextQueryParser tQP = new org.elasticsearch.index.search.TextQueryParser(parseContext, fieldName, text);
        tQP.setPhraseSlop(phraseSlop);
        tQP.setAnalyzer(analyzer);
        tQP.setFuzziness(fuzziness);
        tQP.setFuzzyPrefixLength(prefixLength);
        tQP.setMaxExpansions(maxExpansions);
        tQP.setOccur(occur);
        Query query = tQP.parse(type);
        query.setBoost(boost);
        return query;
    }
}

