/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    @Inject
    public RestSearchScrollAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll/{scroll_id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String scrollId = request.param("scroll_id");
        if (scrollId == null && request.hasContent()) {
            scrollId = request.contentAsString();
        }
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId);
        try {
            String scroll = request.param("scroll");
            if (scroll != null) {
                searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null)));
            }
            searchScrollRequest.listenerThreaded(false);
            SearchOperationThreading operationThreading = SearchOperationThreading.fromString(request.param("operation_threading"), null);
            if (operationThreading != null) {
                if (operationThreading == SearchOperationThreading.NO_THREADS) {
                    operationThreading = SearchOperationThreading.SINGLE_THREAD;
                }
                searchScrollRequest.operationThreading(operationThreading);
            }
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.searchScroll(searchScrollRequest, new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, response.status(), builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestSearchScrollAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

