/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.restjmx;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedOperation;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.support.AbstractRestRequest;
import org.elasticsearch.rest.support.RestUtils;

@MBean(objectName="service=restjmx", description="RestJmx")
public class RestJmxManagement {
    private final RestController controller;

    @Inject
    public RestJmxManagement(RestController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String exec(String method, String resource, String content) throws IOException {
        Channel channel;
        Channel channel2 = channel = new Channel();
        synchronized (channel2) {
            this.controller.dispatchRequest(new Request(method, resource, content), channel);
            if (channel.getResponse() == null) {
                try {
                    channel.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            String result = new String(channel.getResponse().content(), 0, channel.getResponse().contentLength());
            if (channel.getResponse().status().getStatus() >= 400) {
                throw new IOException(result);
            }
            return result;
        }
    }

    static class Channel
    implements RestChannel {
        private RestResponse response;

        Channel() {
        }

        @Override
        public synchronized void sendResponse(RestResponse response) {
            if (response.status() != RestStatus.CONTINUE) {
                this.response = response;
                this.notifyAll();
            }
        }

        public RestResponse getResponse() {
            return this.response;
        }
    }

    static class Request
    extends AbstractRestRequest
    implements RestRequest {
        private final String method;
        private final String uri;
        private final String content;
        private final Map<String, String> params;
        private final String rawPath;
        private final byte[] rawContent;

        Request(String method, String uri, String content) {
            this.method = method;
            this.uri = uri;
            this.content = content;
            this.params = new HashMap<String, String>();
            int pathEndPos = uri.indexOf(63);
            if (pathEndPos < 0) {
                this.rawPath = uri;
            } else {
                this.rawPath = uri.substring(0, pathEndPos);
                RestUtils.decodeQueryString(uri, pathEndPos + 1, this.params);
            }
            this.rawContent = content != null ? content.getBytes() : null;
        }

        @Override
        public RestRequest.Method method() {
            return RestRequest.Method.valueOf(this.method.toUpperCase());
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String rawPath() {
            return this.rawPath;
        }

        @Override
        public boolean hasContent() {
            return this.rawContent != null;
        }

        @Override
        public boolean contentUnsafe() {
            return false;
        }

        @Override
        public byte[] contentByteArray() {
            return this.rawContent;
        }

        @Override
        public int contentByteArrayOffset() {
            return 0;
        }

        @Override
        public int contentLength() {
            return this.rawContent.length;
        }

        @Override
        public String contentAsString() {
            return this.content;
        }

        @Override
        public String header(String name) {
            return null;
        }

        @Override
        public boolean hasParam(String key) {
            return this.params.containsKey(key);
        }

        @Override
        public String param(String key) {
            return this.params.get(key);
        }

        @Override
        public Map<String, String> params() {
            return this.params;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (this.params.containsKey(key)) {
                return this.params.get(key);
            }
            return defaultValue;
        }
    }
}

