/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.search.facet.FacetCollector;

public abstract class AbstractFacetCollector
extends FacetCollector {
    protected final String facetName;
    protected Filter filter;
    private DocSet docSet = null;

    public AbstractFacetCollector(String facetName) {
        this.facetName = facetName;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = this.filter == null ? filter : new AndFilter(ImmutableList.of(filter, this.filter));
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        if (this.filter != null) {
            this.docSet = DocSets.convert(reader, this.filter.getDocIdSet(reader));
        }
        this.doSetNextReader(reader, docBase);
    }

    protected abstract void doSetNextReader(IndexReader var1, int var2) throws IOException;

    @Override
    public void collect(int doc) throws IOException {
        if (this.docSet == null) {
            this.doCollect(doc);
        } else if (this.docSet.get(doc)) {
            this.doCollect(doc);
        }
    }

    protected abstract void doCollect(int var1) throws IOException;
}

