/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.CreateEnsembleOptions;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.BundleUtils;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.utils.Ports;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.internal.OsgiZkClient;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperRetriableUtils;
import org.fusesource.fabric.zookeeper.utils.ZookeeperCommandBuilder;
import org.fusesource.fabric.zookeeper.utils.ZookeeperImportUtils;
import org.linkedin.util.clock.Timespan;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterServiceImpl
implements ZooKeeperClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private FabricService fabricService;
    private boolean ensembleAutoStart = Boolean.parseBoolean(System.getProperty("ensemble.auto.start"));

    public void init() {
        if (this.ensembleAutoStart) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ZooKeeperClusterServiceImpl.this.createLocalServer();
                }
            }).start();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    @Override
    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void createLocalServer() {
        this.createLocalServer(2181);
    }

    public void createLocalServer(int port) {
        String newUser = null;
        String newUserPassword = null;
        AbstractMap userProps = null;
        try {
            userProps = new org.apache.felix.utils.properties.Properties(new File(System.getProperty("karaf.home") + "/etc/users.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load users from etc/users.properties. No users will be imported.", (Throwable)e);
        }
        String zookeeperPassword = System.getProperty("zookeeper.password");
        CreateEnsembleOptions createOpts = CreateEnsembleOptions.build();
        if (userProps != null && !userProps.isEmpty()) {
            newUser = (String)userProps.keySet().iterator().next();
            newUserPassword = (String)userProps.get(newUser);
            createOpts.user(newUser, newUserPassword);
        }
        if (zookeeperPassword != null && !zookeeperPassword.isEmpty()) {
            createOpts.zookeeperPassword(zookeeperPassword);
        }
        this.createLocalServer(port, createOpts);
    }

    public void createLocalServer(int port, CreateEnsembleOptions options) {
        try {
            String version = "1.0";
            String karafName = System.getProperty("karaf.name");
            String minimumPort = System.getProperty("minimum.port");
            String maximumPort = System.getProperty("maximum.port");
            int mappedPort = Ports.mapPortToRange(port, minimumPort, maximumPort);
            if (options.getZookeeperPassword() == null) {
                if (System.getProperties().containsKey("zookeeper.password")) {
                    options.setZookeeperPassword(System.getProperty("zookeeper.password"));
                } else {
                    options.setZookeeperPassword(ZooKeeperRetriableUtils.generatePassword());
                }
            }
            Bundle bundleFabricAgent = BundleUtils.findAndStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent");
            Bundle bundleFabricConfigAdmin = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-configadmin", "mvn:org.fusesource.fabric/fabric-configadmin/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricZooKeeper = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-zookeeper", "mvn:org.fusesource.fabric/fabric-zookeeper/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricJaas = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-jaas", "mvn:org.fusesource.fabric/fabric-jaas/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricCommands = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands", "mvn:org.fusesource.fabric/fabric-commands/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricMavenProxy = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-maven-proxy", "mvn:org.fusesource.fabric/fabric-maven-proxy/" + FabricConstants.FABRIC_VERSION);
            String connectionUrl = HostUtils.getLocalHostName() + ":" + Integer.toString(mappedPort);
            String autoImportFrom = System.getProperty("profiles.auto.import.path");
            Configuration config = this.configurationAdmin.createFactoryConfiguration("org.fusesource.fabric.zookeeper.server");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (autoImportFrom != null) {
                this.loadPropertiesFrom(properties, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.server.properties");
            }
            properties.put("tickTime", "2000");
            properties.put("initLimit", "10");
            properties.put("syncLimit", "5");
            properties.put("dataDir", "data/zookeeper/0000");
            properties.put("clientPort", Integer.toString(mappedPort));
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper.server-0000");
            config.setBundleLocation(null);
            config.update(properties);
            config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
            properties = new Hashtable();
            if (autoImportFrom != null) {
                this.loadPropertiesFrom(properties, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.properties");
            }
            properties.put("zookeeper.url", connectionUrl);
            properties.put("zookeeper.timeout", System.getProperties().containsKey("zookeeper.timeout") ? System.getProperties().getProperty("zookeeper.timeout") : "30000");
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper");
            properties.put("zookeeper.password", options.getZookeeperPassword());
            config.setBundleLocation(null);
            config.update(properties);
            bundleFabricZooKeeper.start();
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, IZKClient.class.getName(), null);
            tracker.open();
            IZKClient client = (IZKClient)tracker.waitForService(5000L);
            if (client == null) {
                throw new IllegalStateException("Timeout waiting for ZooKeeper client to be registered");
            }
            tracker.close();
            client.waitForConnected();
            if (autoImportFrom != null) {
                ZookeeperImportUtils.importFromFileSystem((IZKClient)client, (String)autoImportFrom, (String)"/", null, null, (boolean)false, (boolean)false, (boolean)false);
            }
            String defaultProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, "default"});
            ZooKeeperClusterServiceImpl.setConfigProperty(client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
            ZooKeeperClusterServiceImpl.setConfigProperty(client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", options.getZookeeperPassword());
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), (String)("${zk:" + karafName + "/ip}:" + Integer.toString(mappedPort)));
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), (String)options.getZookeeperPassword());
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version);
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-0000"}), (String)"abstract=true\nhidden=true");
            String profileNode = ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-0000"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            Properties p = new Properties();
            p.put("tickTime", "2000");
            p.put("initLimit", "10");
            p.put("syncLimit", "5");
            p.put("dataDir", "data/zookeeper/0000");
            this.loadPropertiesFrom(p, autoImportFrom + "/fabric/configs/versions/1.0/profiles/default/org.fusesource.fabric.zookeeper.server.properties");
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-0000-1"}), (String)"parents=fabric-ensemble-0000\nhidden=true");
            profileNode = ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-0000-1"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            p = new Properties();
            p.put("clientPort", String.valueOf(mappedPort));
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]), (String)"0000");
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{"0000"}), (String)karafName);
            String fabricProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, "fabric"});
            ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)fabricProfile, (String)"default");
            p = ZooKeeperClusterServiceImpl.getProperties(client, fabricProfile + "/org.fusesource.fabric.agent.properties", new Properties());
            p.put("feature.fabric-commands", "fabric-commands");
            ZooKeeperRetriableUtils.set((IZKClient)client, (String)(fabricProfile + "/org.fusesource.fabric.agent.properties"), (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{karafName}), (String)version);
            String assignedProfile = System.getProperty("profile");
            if (assignedProfile != null && !assignedProfile.isEmpty() && !"fabric".equals(assignedProfile)) {
                ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, karafName}), (String)("fabric fabric-ensemble-0000-1 " + assignedProfile));
            } else {
                ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, karafName}), (String)"fabric fabric-ensemble-0000-1");
            }
            ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)(defaultProfile + "/org.fusesource.fabric.jaas/encryption.enabled"), (String)"${zk:/fabric/authentication/encryption.enabled}");
            ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)"/fabric/authentication/encryption.enabled", (String)"true");
            ZooKeeperRetriableUtils.createDefault((IZKClient)client, (String)"/fabric/authentication/domain", (String)"karaf");
            this.addUsersToZookeeper(client, options.getUsers());
            ZookeeperCommandBuilder.fixAcls((String)"/", (Boolean)true).execute(client);
            if (this.ensembleAutoStart) {
                System.setProperty("ensemble.auto.start", Boolean.FALSE.toString());
                File file = new File(System.getProperty("karaf.base") + "/etc/system.properties");
                org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
                props.put("ensemble.auto.start", Boolean.FALSE.toString());
                props.save();
            }
            bundleFabricConfigAdmin.start();
            bundleFabricJaas.start();
            bundleFabricCommands.start();
            bundleFabricMavenProxy.start();
            if (!System.getProperties().containsKey("agent.auto.start") || Boolean.parseBoolean(System.getProperty("agent.auto.start"))) {
                bundleFabricAgent = BundleUtils.findOrInstallBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent  ", "mvn:org.fusesource.fabric/fabric-agent/" + FabricConstants.FABRIC_VERSION);
                bundleFabricAgent.start();
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to create zookeeper server configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFrom(Hashtable hashtable, String from) {
        FileInputStream is = null;
        Properties properties = new Properties();
        try {
            is = new FileInputStream(from);
            properties.load(is);
            for (String key : properties.stringPropertyNames()) {
                hashtable.put(key, properties.get(key));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void clean() {
        try {
            Configuration[] configs;
            while ((configs = this.configurationAdmin.listConfigurations("(|(service.factoryPid=org.fusesource.fabric.zookeeper.server)(service.pid=org.fusesource.fabric.zookeeper))")) != null && configs.length > 0) {
                for (Configuration config : configs) {
                    config.delete();
                }
                Thread.sleep(100L);
            }
            File zkDir = new File("data/zookeeper");
            if (zkDir.isDirectory()) {
                File newZkDir = new File("data/zookeeper." + System.currentTimeMillis());
                if (!zkDir.renameTo(newZkDir)) {
                    newZkDir = zkDir;
                }
                ZooKeeperClusterServiceImpl.delete(newZkDir);
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to delete zookeeper configuration", e);
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterServiceImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    @Override
    public List<String> getEnsembleContainers() {
        try {
            Configuration[] configs = this.configurationAdmin.listConfigurations("(service.pid=org.fusesource.fabric.zookeeper)");
            if (configs == null || configs.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (this.zooKeeper.exists(ZkPath.CONFIG_ENSEMBLES.getPath(new String[0])) != null) {
                String clusterId = ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
                String containers = ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{clusterId}));
                Collections.addAll(list, containers.split(","));
            }
            return list;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper quorum containers", e);
        }
    }

    @Override
    public String getZooKeeperUrl() {
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
            String zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            if (zooKeeperUrl == null) {
                throw new IllegalStateException("Unable to find the zookeeper url");
            }
            return zooKeeperUrl;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper current url", e);
        }
    }

    @Override
    public void createCluster(List<String> containers) {
        this.createCluster(containers, CreateEnsembleOptions.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCluster(List<String> containers, CreateEnsembleOptions options) {
        block25: {
            try {
                String zooKeeperUrl;
                if (options.getZookeeperPassword() == null) {
                    if (System.getProperties().containsKey("zookeeper.password")) {
                        options.setZookeeperPassword(System.getProperty("zookeeper.password"));
                    } else {
                        options.setZookeeperPassword(ZooKeeperRetriableUtils.generatePassword());
                    }
                }
                if (containers == null || containers.size() == 2) {
                    throw new IllegalArgumentException("One or at least 3 containers must be used to create a zookeeper ensemble");
                }
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                String string = zooKeeperUrl = config != null && config.getProperties() != null ? (String)config.getProperties().get("zookeeper.url") : null;
                if (zooKeeperUrl == null) {
                    if (containers.size() != 1 || !containers.get(0).equals(System.getProperty("karaf.name"))) {
                        throw new FabricException("The first zookeeper cluster must be configured on this container only.");
                    }
                    this.createLocalServer(2181, options);
                    return;
                }
                String version = ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
                for (String container : containers) {
                    if (ZooKeeperRetriableUtils.exists((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{container})) != null) continue;
                    throw new FabricException("The container " + container + " is not alive");
                }
                HashMap<String, List<Integer>> usedPorts = new HashMap<String, List<Integer>>();
                String oldClusterId = ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
                if (oldClusterId != null) {
                    Properties p = ZooKeeperClusterServiceImpl.toProperties(ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)(ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-" + oldClusterId}) + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties")));
                    for (Object n : p.keySet()) {
                        String node = (String)n;
                        if (!node.startsWith("server.")) continue;
                        String data = ZooKeeperRetriableUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)(ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-" + oldClusterId}) + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties#" + node));
                        this.addUsedPorts(usedPorts, data);
                    }
                    String datas = ZooKeeperRetriableUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url"));
                    for (String data : datas.split(",")) {
                        this.addUsedPorts(usedPorts, data);
                    }
                }
                String newClusterId = oldClusterId == null ? "0000" : new DecimalFormat("0000").format(Integer.parseInt(oldClusterId) + 1);
                ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-" + newClusterId}), (String)"abstract=true\nhidden=true");
                String profileNode = ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-" + newClusterId}) + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                Properties profileNodeProperties = new Properties();
                profileNodeProperties.put("tickTime", "2000");
                profileNodeProperties.put("initLimit", "10");
                profileNodeProperties.put("syncLimit", "5");
                profileNodeProperties.put("dataDir", "data/zookeeper/" + newClusterId);
                int index = 1;
                String connectionUrl = "";
                String realConnectionUrl = "";
                String containerList = "";
                for (String container : containers) {
                    version = ZooKeeperRetriableUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{container}));
                    String ip = ZooKeeperRetriableUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{container}));
                    String minimumPort = String.valueOf(0);
                    String maximumPort = String.valueOf(65535);
                    if (this.zooKeeper.exists(ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{container})) != null) {
                        minimumPort = ZooKeeperRetriableUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{container}));
                    }
                    if (this.zooKeeper.exists(ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{container})) != null) {
                        maximumPort = ZooKeeperRetriableUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{container}));
                    }
                    String profNode = ZkPath.CONFIG_ENSEMBLE_PROFILE.getPath(new String[]{"fabric-ensemble-" + newClusterId + "-" + Integer.toString(index)});
                    String pidNode = profNode + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                    Properties pidNodeProperties = new Properties();
                    ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)profNode, (String)("parents=fabric-ensemble-" + newClusterId + "\nhidden=true"));
                    String port1 = Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(2181, minimumPort, maximumPort)));
                    if (containers.size() > 1) {
                        String port2 = Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(2888, minimumPort, maximumPort)));
                        String port3 = Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(3888, minimumPort, maximumPort)));
                        profileNodeProperties.put("server." + Integer.toString(index), "${zk:" + container + "/ip}:" + port2 + ":" + port3);
                        pidNodeProperties.put("server.id", Integer.toString(index));
                    }
                    pidNodeProperties.put("clientPort", port1);
                    ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)pidNode, (String)ZooKeeperClusterServiceImpl.toString(pidNodeProperties));
                    ZooKeeperRetriableUtils.add((IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + version + "/containers/" + container), (String)("fabric-ensemble-" + newClusterId + "-" + Integer.toString(index)));
                    if (connectionUrl.length() > 0) {
                        connectionUrl = connectionUrl + ",";
                        realConnectionUrl = realConnectionUrl + ",";
                    }
                    connectionUrl = connectionUrl + "${zk:" + container + "/ip}:" + port1;
                    realConnectionUrl = realConnectionUrl + ip + ":" + port1;
                    if (containerList.length() > 0) {
                        containerList = containerList + ",";
                    }
                    containerList = containerList + container;
                    ++index;
                }
                ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(profileNodeProperties));
                if (oldClusterId != null) {
                    Properties properties = ZooKeeperRetriableUtils.getProperties((IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + version + "/profiles/default/org.fusesource.fabric.zookeeper.properties"));
                    properties.put("zookeeper.url", ZooKeeperRetriableUtils.getSubstitutedData((IZKClient)this.zooKeeper, (String)realConnectionUrl));
                    properties.put("zookeeper.password", options.getZookeeperPassword());
                    OsgiZkClient dst = new OsgiZkClient();
                    dst.updated((Dictionary)properties);
                    try {
                        dst.waitForConnected(new Timespan(30L, Timespan.TimeUnit.SECOND));
                        ZooKeeperRetriableUtils.copy((IZKClient)this.zooKeeper, (IZKClient)dst, (String)"/fabric/registry");
                        ZooKeeperRetriableUtils.copy((IZKClient)this.zooKeeper, (IZKClient)dst, (String)"/fabric/authentication");
                        ZooKeeperRetriableUtils.copy((IZKClient)this.zooKeeper, (IZKClient)dst, (String)"/fabric/configs");
                        for (String container : containers) {
                            ZookeeperCommandBuilder.delete((String)("/fabric/registry/containers/alive/" + container)).execute((IZKClient)dst);
                        }
                        ZooKeeperRetriableUtils.set((IZKClient)dst, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]), (String)newClusterId);
                        ZooKeeperRetriableUtils.set((IZKClient)dst, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{newClusterId}), (String)containerList);
                        ZooKeeperRetriableUtils.set((IZKClient)dst, (String)ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), (String)connectionUrl);
                        ZooKeeperRetriableUtils.set((IZKClient)dst, (String)ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), (String)options.getZookeeperPassword());
                        ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), (String)connectionUrl);
                        ZooKeeperRetriableUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), (String)options.getZookeeperPassword());
                        for (String v : this.zooKeeper.getChildren("/fabric/configs/versions/")) {
                            for (String container : dst.getChildren("/fabric/configs/versions/" + v + "/containers")) {
                                ZooKeeperRetriableUtils.remove((IZKClient)dst, (String)("/fabric/configs/versions/" + v + "/containers/" + container), (String)("fabric-ensemble-" + oldClusterId + "-.*"));
                            }
                            ZooKeeperClusterServiceImpl.setConfigProperty((IZKClient)dst, "/fabric/configs/versions/" + v + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
                            ZooKeeperClusterServiceImpl.setConfigProperty((IZKClient)dst, "/fabric/configs/versions/" + v + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
                            ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + v + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
                            ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + v + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
                        }
                        break block25;
                    }
                    finally {
                        dst.close();
                    }
                }
                ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
                ZooKeeperClusterServiceImpl.setConfigProperty(this.zooKeeper, "/fabric/configs/versions/" + version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
            }
            catch (Exception e) {
                throw new FabricException("Unable to create zookeeper quorum: " + e.getMessage(), e);
            }
        }
    }

    public static String toString(Properties source) throws IOException {
        StringWriter writer = new StringWriter();
        source.store(writer, null);
        return writer.toString();
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static Properties getProperties(IZKClient client, String file, Properties defaultValue) throws InterruptedException, KeeperException, IOException {
        try {
            String v = ZooKeeperRetriableUtils.get((IZKClient)client, (String)file);
            if (v != null) {
                return ZooKeeperClusterServiceImpl.toProperties(v);
            }
            return defaultValue;
        }
        catch (KeeperException.NoNodeException e) {
            return defaultValue;
        }
    }

    public static void setConfigProperty(IZKClient client, String file, String prop, String value) throws InterruptedException, KeeperException, IOException {
        Properties p = ZooKeeperClusterServiceImpl.getProperties(client, file, new Properties());
        p.setProperty(prop, value);
        ZooKeeperRetriableUtils.set((IZKClient)client, (String)file, (String)ZooKeeperClusterServiceImpl.toString(p));
    }

    private int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    private void addUsedPorts(Map<String, List<Integer>> usedPorts, String data) {
        String[] parts = data.split(":");
        List<Integer> ports = usedPorts.get(parts[0]);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(parts[0], ports);
        }
        for (int i = 1; i < parts.length; ++i) {
            ports.add(Integer.parseInt(parts[i]));
        }
    }

    @Override
    public void addToCluster(List<String> containers) {
        CreateEnsembleOptions options = CreateEnsembleOptions.build();
        options.setZookeeperPassword(this.fabricService.getZookeeperPassword());
        this.addToCluster(containers, options);
    }

    @Override
    public void addToCluster(List<String> containers, CreateEnsembleOptions options) {
        try {
            List<String> current = this.getEnsembleContainers();
            current.addAll(containers);
            this.createCluster(current, options);
        }
        catch (Exception e) {
            throw new FabricException("Unable to add containers to fabric ensemble: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeFromCluster(List<String> containers) {
        CreateEnsembleOptions options = CreateEnsembleOptions.build();
        options.setZookeeperPassword(this.fabricService.getZookeeperPassword());
        this.removeFromCluster(containers, options);
    }

    @Override
    public void removeFromCluster(List<String> containers, CreateEnsembleOptions options) {
        try {
            List<String> current = this.getEnsembleContainers();
            current.removeAll(containers);
            this.createCluster(current, options);
        }
        catch (Exception e) {
            throw new FabricException("Unable to remove containers to fabric ensemble: " + e.getMessage(), e);
        }
    }

    private void addUsersToZookeeper(IZKClient zookeeper, Map<String, String> users) throws KeeperException, InterruptedException, TimeoutException {
        Pattern p = Pattern.compile("(.+),(.+)");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("encryption.prefix", "{CRYPT}");
        options.put("encryption.suffix", "{CRYPT}");
        options.put("encryption.enabled", "true");
        options.put("encryption.enabled", "true");
        options.put("encryption.algorithm", "MD5");
        options.put("encryption.encoding", "hexadecimal");
        options.put(BundleContext.class.getName(), (String)this.bundleContext);
        EncryptionSupport encryptionSupport = new EncryptionSupport(options);
        Encryption encryption = encryptionSupport.getEncryption();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : users.entrySet()) {
            String user = entry.getKey();
            Matcher m = p.matcher(entry.getValue());
            if (!m.matches() || m.groupCount() < 2) continue;
            String password = m.group(1).trim();
            if (!password.startsWith(encryptionSupport.getEncryptionPrefix()) || !password.endsWith(encryptionSupport.getEncryptionSuffix())) {
                password = encryptionSupport.getEncryptionPrefix() + encryption.encryptPassword(m.group(1)).trim() + encryptionSupport.getEncryptionSuffix();
            }
            String role = m.group(2).trim();
            sb.append(user).append("=").append(password).append(",").append(role).append("\n");
        }
        String allUsers = sb.toString();
        ZooKeeperRetriableUtils.createDefault((IZKClient)zookeeper, (String)"/fabric/authentication/users", (String)allUsers);
    }
}

