/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindBlockDeviceMappingToIndexedFormParams
implements Binder {
    private static final String deviceNamePattern = "BlockDeviceMapping.%d.DeviceName";
    private static final String volumeIdPattern = "BlockDeviceMapping.%d.Ebs.VolumeId";
    private static final String deleteOnTerminationPattern = "BlockDeviceMapping.%d.Ebs.DeleteOnTermination";

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"this binder is only valid for Map");
        Map blockDeviceMapping = (Map)input;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Map.Entry ebsBlockDeviceName : blockDeviceMapping.entrySet()) {
            builder.put((Object)String.format(volumeIdPattern, amazonOneBasedIndex), (Object)((BlockDevice)ebsBlockDeviceName.getValue()).getVolumeId());
            builder.put((Object)String.format(deviceNamePattern, amazonOneBasedIndex), ebsBlockDeviceName.getKey());
            builder.put((Object)String.format(deleteOnTerminationPattern, amazonOneBasedIndex), (Object)String.valueOf(((BlockDevice)ebsBlockDeviceName.getValue()).isDeleteOnTermination()));
            ++amazonOneBasedIndex;
        }
        SetMultimap forms = Multimaps.forMap((Map)builder.build());
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }
}

