/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.predicates.Retryables;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Preconditions2;

@Singleton
public class EC2ComputeService
extends BaseComputeService {
    private final EC2Client ec2Client;
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final LoadingCache<RegionAndName, String> securityGroupMap;
    private final GroupNamingConvention.Factory namingConvention;
    @Inject(optional=true)
    @Named(value="jclouds.compute.resourcename-delimiter")
    char delimiter = (char)35;

    @Inject
    protected EC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, EC2Client ec2Client, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, Optional<ImageExtension> imageExtension, GroupNamingConvention.Factory namingConvention) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, executor, imageExtension);
        this.ec2Client = ec2Client;
        this.credentialsMap = credentialsMap;
        this.securityGroupMap = securityGroupMap;
        this.namingConvention = namingConvention;
    }

    @VisibleForTesting
    void deleteSecurityGroup(String region, String group) {
        Preconditions2.checkNotEmpty((String)region, (String)"region");
        Preconditions2.checkNotEmpty((String)group, (String)"group");
        String groupName = this.namingConvention.create().sharedNameForGroup(group);
        if (this.ec2Client.getSecurityGroupServices().describeSecurityGroupsInRegion(region, groupName).size() > 0) {
            this.logger.debug(">> deleting securityGroup(%s)", new Object[]{groupName});
            this.ec2Client.getSecurityGroupServices().deleteSecurityGroupInRegion(region, groupName);
            this.securityGroupMap.invalidate((Object)new RegionNameAndIngressRules(region, groupName, null, false));
            this.logger.debug("<< deleted securityGroup(%s)", new Object[]{groupName});
        }
    }

    @VisibleForTesting
    void deleteKeyPair(String region, String group) {
        for (KeyPair keyPair : this.ec2Client.getKeyPairServices().describeKeyPairsInRegion(region, new String[0])) {
            String keyName = keyPair.getKeyName();
            Predicate keyNameMatcher = this.namingConvention.create().containsGroup(group);
            String oldKeyNameRegex = String.format("jclouds#%s#%s#%s", group, region, "[0-9a-f]+").replace('#', this.delimiter);
            if (!keyNameMatcher.apply((Object)keyName) && !keyName.matches(oldKeyNameRegex)) continue;
            ImmutableSet<String> instancesUsingKeyPair = this.extractIdsFromInstances(Iterables.filter((Iterable)Iterables.concat(this.ec2Client.getInstanceServices().describeInstancesInRegion(region, new String[0])), this.usingKeyPairAndNotDead(keyPair)));
            if (instancesUsingKeyPair.size() > 0) {
                this.logger.debug("<< inUse keyPair(%s), by (%s)", new Object[]{keyPair.getKeyName(), instancesUsingKeyPair});
                continue;
            }
            this.logger.debug(">> deleting keyPair(%s)", new Object[]{keyPair.getKeyName()});
            this.ec2Client.getKeyPairServices().deleteKeyPairInRegion(region, keyPair.getKeyName());
            this.credentialsMap.remove(new RegionAndName(region, keyPair.getKeyName()));
            this.credentialsMap.remove(new RegionAndName(region, group));
            this.logger.debug("<< deleted keyPair(%s)", new Object[]{keyPair.getKeyName()});
        }
    }

    protected ImmutableSet<String> extractIdsFromInstances(Iterable<? extends RunningInstance> deadOnes) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(deadOnes, (Function)new Function<RunningInstance, String>(){

            public String apply(RunningInstance input) {
                return input.getId();
            }
        }));
    }

    protected Predicate<RunningInstance> usingKeyPairAndNotDead(final KeyPair keyPair) {
        return new Predicate<RunningInstance>(){

            public boolean apply(RunningInstance input) {
                switch (input.getInstanceState()) {
                    case TERMINATED: 
                    case SHUTTING_DOWN: {
                        return false;
                    }
                }
                return keyPair.getKeyName().equals(input.getKeyName());
            }
        };
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        ImmutableMultimap.Builder regionGroups = ImmutableMultimap.builder();
        for (NodeMetadata nodeMetadata : deadNodes) {
            if (nodeMetadata.getGroup() == null) continue;
            regionGroups.put((Object)AWSUtils.parseHandle((String)nodeMetadata.getId())[0], (Object)nodeMetadata.getGroup());
        }
        for (Map.Entry entry : regionGroups.build().entries()) {
            this.cleanUpIncidentalResources((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void cleanUpIncidentalResources(final String region, final String group) {
        int maxAttempts = 3;
        Retryables.retryNumTimes((Predicate)new Predicate<Void>(){

            public boolean apply(Void input) {
                try {
                    EC2ComputeService.this.logger.debug(">> deleting incidentalResources(%s @ %s)", new Object[]{region, group});
                    EC2ComputeService.this.deleteSecurityGroup(region, group);
                    EC2ComputeService.this.deleteKeyPair(region, group);
                    EC2ComputeService.this.logger.debug("<< deleted incidentalResources(%s @ %s)", new Object[]{region, group});
                    return true;
                }
                catch (IllegalStateException e) {
                    EC2ComputeService.this.logger.debug("<< inUse incidentalResources(%s @ %s)", new Object[]{region, group});
                    return false;
                }
            }
        }, (Object)null, (int)3);
    }

    public EC2TemplateOptions templateOptions() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.templateOptions());
    }
}

