/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.predicates.InstancePresent;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.util.EC2ComputeUtils;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class EC2CreateNodesInGroupThenAddToSet
implements CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject
    @Named(value="jclouds.ec2.auto-allocate-elastic-ips")
    @VisibleForTesting
    boolean autoAllocateElasticIps = false;
    @VisibleForTesting
    final EC2Client client;
    @VisibleForTesting
    final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    @VisibleForTesting
    final LoadingCache<RegionAndName, String> elasticIpCache;
    @VisibleForTesting
    final CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize;
    @VisibleForTesting
    final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    @VisibleForTesting
    final ComputeUtils utils;
    final InstancePresent instancePresent;
    final LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials;
    final Map<String, Credentials> credentialStore;
    final Provider<TemplateBuilder> templateBuilderProvider;
    public static Function<RunningInstance, RegionAndName> instanceToRegionAndName = new Function<RunningInstance, RegionAndName>(){

        public RegionAndName apply(RunningInstance from) {
            return new RegionAndName(from.getRegion(), from.getId());
        }
    };

    @Inject
    protected EC2CreateNodesInGroupThenAddToSet(EC2Client client, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, Provider<TemplateBuilder> templateBuilderProvider, CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, InstancePresent instancePresent, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils) {
        this.client = (EC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.elasticIpCache = (LoadingCache)Preconditions.checkNotNull(elasticIpCache, (Object)"elasticIpCache");
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.templateBuilderProvider = (Provider)Preconditions.checkNotNull(templateBuilderProvider, (Object)"templateBuilderProvider");
        this.instancePresent = (InstancePresent)Preconditions.checkNotNull((Object)instancePresent, (Object)"instancePresent");
        this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize = (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)Preconditions.checkNotNull((Object)createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, (Object)"createKeyPairAndSecurityGroupsAsNeededAndReturncustomize");
        this.runningInstanceToNodeMetadata = (Function)Preconditions.checkNotNull(runningInstanceToNodeMetadata, (Object)"runningInstanceToNodeMetadata");
        this.instanceToCredentials = (LoadingCache)Preconditions.checkNotNull(instanceToCredentials, (Object)"instanceToCredentials");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.utils = (ComputeUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
    }

    public Map<?, Future<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        Template mutableTemplate = template.clone();
        Iterable<String> ips = this.allocateElasticIpsInRegion(count, mutableTemplate);
        Iterable<? extends RunningInstance> started = this.createKeyPairAndSecurityGroupsAsNeededThenRunInstances(group, count, mutableTemplate);
        Iterable ids = Iterables.transform(started, instanceToRegionAndName);
        String idsString = Joiner.on((char)',').join(ids);
        if (Iterables.size((Iterable)ids) > 0) {
            this.logger.debug("<< started instances(%s)", new Object[]{idsString});
            Iterables.all((Iterable)ids, (Predicate)this.instancePresent);
            this.logger.debug("<< present instances(%s)", new Object[]{idsString});
            this.populateCredentials(started, template.getOptions());
        }
        this.assignElasticIpsToInstances(ips, started);
        return this.utils.customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap(mutableTemplate.getOptions(), Iterables.transform(started, this.runningInstanceToNodeMetadata), goodNodes, badNodes, customizationResponses);
    }

    protected void populateCredentials(Iterable<? extends RunningInstance> started, TemplateOptions options) {
        RunningInstance runningInstance;
        LoginCredentials credentials = null;
        Iterator<? extends RunningInstance> i$ = started.iterator();
        while (i$.hasNext() && (credentials = (LoginCredentials)((Optional)this.instanceToCredentials.apply((Object)(runningInstance = i$.next()))).orNull()) == null) {
        }
        if ((credentials = DefaultCredentialsFromImageOrOverridingCredentials.overrideDefaultCredentialsWithOptionsIfPresent(credentials, (RunScriptOptions)options)) != null) {
            for (RunningInstance runningInstance2 : started) {
                this.credentialStore.put("node#" + runningInstance2.getRegion() + "/" + runningInstance2.getId(), (Credentials)credentials);
            }
        }
    }

    protected Iterable<String> allocateElasticIpsInRegion(int count, Template template) {
        ImmutableSet.Builder ips = ImmutableSet.builder();
        if (!this.autoAllocateElasticIps) {
            return ips.build();
        }
        String region = AWSUtils.getRegionFromLocationOrNull((Location)template.getLocation());
        this.logger.debug("<< allocating %d elastic IPs for nodes in region (%s)", new Object[]{count, region});
        for (int i = 0; i < count; ++i) {
            ips.add((Object)this.client.getElasticIPAddressServices().allocateAddressInRegion(region));
        }
        return ips.build();
    }

    protected void assignElasticIpsToInstances(Iterable<String> ips, Iterable<? extends RunningInstance> startedInstances) {
        if (!this.autoAllocateElasticIps) {
            return;
        }
        int i = 0;
        for (RunningInstance runningInstance : startedInstances) {
            String ip = (String)Iterables.get(ips, (int)i);
            String region = runningInstance.getRegion();
            String id = runningInstance.getId();
            RegionAndName coordinates = new RegionAndName(region, id);
            this.logger.debug(">> awaiting status running instance(%s)", new Object[]{coordinates});
            AtomicReference<Object> node = new AtomicReference<Object>(this.runningInstanceToNodeMetadata.apply((Object)runningInstance));
            this.nodeRunning.apply(node);
            this.logger.trace("<< running instance(%s)", new Object[]{coordinates});
            this.logger.debug(">> associating elastic IP %s to instance %s", new Object[]{ip, coordinates});
            this.client.getElasticIPAddressServices().associateAddressInRegion(region, ip, id);
            this.logger.trace("<< associated elastic IP %s to instance %s", new Object[]{ip, coordinates});
            this.elasticIpCache.put((Object)coordinates, (Object)ip);
        }
    }

    protected Iterable<? extends RunningInstance> createKeyPairAndSecurityGroupsAsNeededThenRunInstances(String group, int count, Template template) {
        String region = AWSUtils.getRegionFromLocationOrNull((Location)template.getLocation());
        String zone = EC2ComputeUtils.getZoneFromLocationOrNull(template.getLocation());
        RunInstancesOptions instanceOptions = this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize.execute(region, group, template);
        return this.createNodesInRegionAndZone(region, zone, group, count, template, instanceOptions);
    }

    protected Iterable<? extends RunningInstance> createNodesInRegionAndZone(String region, String zone, String group, int count, Template template, RunInstancesOptions instanceOptions) {
        int countStarted = 0;
        int tries = 0;
        Object started = ImmutableSet.of();
        while (countStarted < count && tries++ < count) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> running %d instance region(%s) zone(%s) ami(%s) params(%s)", new Object[]{count - countStarted, region, zone, template.getImage().getProviderId(), instanceOptions.buildFormParameters()});
            }
            if ((countStarted = Iterables.size((Iterable)(started = Iterables.concat((Iterable)started, this.client.getInstanceServices().runInstancesInRegion(region, zone, template.getImage().getProviderId(), 1, count - countStarted, instanceOptions))))) >= count) continue;
            this.logger.debug(">> not enough instances (%d/%d) started, attempting again", new Object[]{countStarted, count});
        }
        return started;
    }
}

