/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.features;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.utils.features.FeatureUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.tracker.NodeEvent;
import org.linkedin.zookeeper.tracker.NodeEventsListener;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.linkedin.zookeeper.tracker.ZKStringDataReader;
import org.linkedin.zookeeper.tracker.ZooKeeperTreeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricFeaturesServiceImpl
implements FeaturesService,
NodeEventsListener<String>,
LifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesService.class);
    private FabricService fabricService;
    private IZKClient zooKeeper;
    private ZooKeeperTreeTracker<String> profilesTracker;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final Set<Feature> allfeatures = new HashSet<Feature>();
    private final Set<Feature> installed = new HashSet<Feature>();

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
        this.profilesTracker.destroy();
    }

    public void onEvents(Collection<NodeEvent<String>> nodeEvents) {
        this.repositories.clear();
        this.allfeatures.clear();
        this.installed.clear();
    }

    public void onConnected() {
        this.profilesTracker = new ZooKeeperTreeTracker((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), ZkPath.CONFIG_VERSIONS.getPath(new String[0]));
        try {
            this.profilesTracker.track((NodeEventsListener)this);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while setting tracker for Fabric Features Service.", (Throwable)e);
        }
        catch (KeeperException e) {
            LOGGER.error("Error while setting tracker for Fabric Features Service.", (Throwable)e);
        }
        this.onEvents(null);
    }

    public void onDisconnected() {
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        FeatureValidationUtil.validate(uri);
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.addRepository(uri, true);
    }

    @Override
    public void addRepository(URI uri, boolean b) throws Exception {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.removeRepository(uri, true);
    }

    @Override
    public void removeRepository(URI uri, boolean b) throws Exception {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
    }

    @Override
    public Repository[] listRepositories() {
        if (this.repositories.isEmpty()) {
            LinkedHashSet<String> repositoryUris = new LinkedHashSet<String>();
            Container container = this.fabricService.getCurrentContainer();
            Version version = container.getVersion();
            Profile[] profiles = this.fabricService.getProfiles(version.getName());
            if (profiles != null) {
                for (Profile profile : profiles) {
                    if (profile.getRepositories() == null) continue;
                    for (String uri : profile.getRepositories()) {
                        repositoryUris.add(uri);
                        this.addRepositoryUri(uri, repositoryUris);
                    }
                }
            }
            for (String uri : repositoryUris) {
                try {
                    this.repositories.add(new RepositoryImpl(new URI(uri)));
                }
                catch (URISyntaxException e) {
                    LOGGER.debug("Error while adding repository with uri {}.", (Object)uri);
                }
            }
        }
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }

    @Override
    public void installFeature(String s) throws Exception {
        this.installFeature(s, (EnumSet<FeaturesService.Option>)null);
    }

    @Override
    public void installFeature(String s, EnumSet<FeaturesService.Option> options) throws Exception {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public void installFeature(String s, String s2) throws Exception {
        this.installFeature(s, s2, null);
    }

    @Override
    public void installFeature(String s, String s2, EnumSet<FeaturesService.Option> options) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", featureName));
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", feature.getName()));
    }

    @Override
    public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (Feature feature : features) {
            sb.append("--feature ").append(feature.getName());
        }
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", sb.toString()));
    }

    @Override
    public void uninstallFeature(String s) throws Exception {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public void uninstallFeature(String s, String s2) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", featureName));
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        if (this.allfeatures.isEmpty()) {
            Repository[] repositories;
            for (Repository repository : repositories = this.listRepositories()) {
                try {
                    for (Feature feature : repository.getFeatures()) {
                        if (this.allfeatures.contains(feature)) continue;
                        this.allfeatures.add(feature);
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Could not load features from %s.", (Object)repository.getURI());
                }
            }
        }
        return this.allfeatures.toArray(new Feature[this.allfeatures.size()]);
    }

    @Override
    public Feature[] listInstalledFeatures() {
        if (this.installed.isEmpty()) {
            try {
                Map<String, Map<String, Feature>> allFeatures = this.getFeatures(this.listProfileRepositories());
                Container container = this.fabricService.getCurrentContainer();
                Profile[] profiles = container.getProfiles();
                if (profiles != null) {
                    for (Profile profile : profiles) {
                        List featureNames = profile.getFeatures();
                        for (String featureName : featureNames) {
                            try {
                                Feature f;
                                if (featureName.contains("/")) {
                                    String[] parts = featureName.split("/");
                                    String name = parts[0];
                                    String version = parts[1];
                                    f = allFeatures.get(name).get(version);
                                } else {
                                    TreeMap versionMap = (TreeMap)allFeatures.get(featureName);
                                    f = (Feature)versionMap.lastEntry().getValue();
                                }
                                this.addFeatures(f, this.installed);
                            }
                            catch (Exception ex) {
                                LOGGER.debug("Error while adding {} to the features list");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error retrieveing features.", (Throwable)e);
            }
        }
        return this.installed.toArray(new Feature[this.installed.size()]);
    }

    @Override
    public boolean isInstalled(Feature feature) {
        if (this.installed.isEmpty()) {
            this.listInstalledFeatures();
        }
        return this.installed.contains(feature);
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        Feature[] features;
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature[] features;
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
            return feature;
        }
        return null;
    }

    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        return this.getFeatures(this.listRepositories());
    }

    protected Map<String, Map<String, Feature>> getFeatures(Repository[] repositories) throws Exception {
        HashMap<String, Map<String, Feature>> features = new HashMap<String, Map<String, Feature>>();
        for (Repository repo : repositories) {
            try {
                for (Feature f : repo.getFeatures()) {
                    if (features.get(f.getName()) == null) {
                        TreeMap<String, Feature> versionMap = new TreeMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        features.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)features.get(f.getName())).put(f.getVersion(), f);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Could not load features from %s.", (Object)repo.getURI());
            }
        }
        return features;
    }

    private Repository[] listProfileRepositories() {
        LinkedHashSet<String> repositoryUris = new LinkedHashSet<String>();
        LinkedHashSet<RepositoryImpl> repositories = new LinkedHashSet<RepositoryImpl>();
        Container container = this.fabricService.getCurrentContainer();
        HashSet<Profile> profilesWithParents = new HashSet<Profile>();
        Profile[] profiles = container.getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                this.addProfiles(profile, profilesWithParents);
            }
            for (Profile profile : profilesWithParents) {
                if (profile.getRepositories() == null) continue;
                for (String uri : profile.getRepositories()) {
                    repositoryUris.add(uri);
                    this.addRepositoryUri(uri, repositoryUris);
                }
            }
        }
        for (String uri : repositoryUris) {
            try {
                repositories.add(new RepositoryImpl(new URI(uri)));
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Error while adding repository with uri {}.", (Object)uri);
            }
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    protected void addRepositoryUri(String uri, Set<String> repositoryUris) {
        if (repositoryUris.contains(uri)) {
            return;
        }
        repositoryUris.add(uri);
        try {
            RepositoryImpl repository = new RepositoryImpl(new URI(uri));
            URI[] internalUris = repository.getRepositories();
            if (internalUris != null) {
                for (URI u : internalUris) {
                    this.addRepositoryUri(u.toString(), repositoryUris);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error while adding internal repositories of {}.", (Object)uri);
        }
    }

    protected void addProfiles(Profile profile, Set<Profile> profiles) {
        if (profiles.contains(profile)) {
            return;
        }
        profiles.add(profile);
        for (Profile parent : profile.getParents()) {
            this.addProfiles(parent, profiles);
        }
    }

    protected void addFeatures(Feature feature, Set<Feature> features) {
        if (features.contains(feature)) {
            return;
        }
        features.add(feature);
        for (Feature dependency : feature.getDependencies()) {
            this.addFeatures(FeatureUtils.search(dependency.getName(), dependency.getVersion(), this.repositories), features);
        }
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

