/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.CreateEnsembleOptions;
import org.fusesource.fabric.api.CreateSshContainerOptions;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;
import org.fusesource.fabric.utils.FabricValidations;
import org.fusesource.fabric.utils.shell.ShellUtils;

@Command(name="container-create-ssh", scope="fabric", description="Creates one or more new containers via SSH", detailedDescription="classpath:containerCreateSsh.txt")
public class ContainerCreateSsh
extends ContainerCreateSupport {
    @Option(name="--host", required=true, description="Host name to SSH into")
    private String host;
    @Option(name="--path", description="Path on the remote filesystem where the container is to be installed.")
    private String path;
    @Option(name="--user", description="User name for login.")
    private String user;
    @Option(name="--password", description="Password for login. If the password is omitted, private key authentication is used instead.")
    private String password;
    @Option(name="--port", description="The IP port number for the SSH connection.")
    private int port = 22;
    @Option(name="--min-port", multiValued=false, description="The minimum port of the allowed port range")
    private int minimumPort = 0;
    @Option(name="--max-port", multiValued=false, description="The maximum port of the allowed port range")
    private int maximumPort = 65535;
    @Option(name="--ssh-retries", description="Number of retries to connect on SSH")
    private int sshRetries;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Option(name="--private-key", description="The path to the private key on the filesystem. Default is ~/.ssh/id_rsa on *NIX platforms or C:\\Documents and Settings\\<UserName>\\.ssh\\id_rsa on Windows.")
    private String privateKeyFile;
    @Option(name="--pass-phrase", description="The pass phrase of the key. This is for use with private keys that require a pass phrase.")
    private String passPhrase;
    @Option(name="--new-user", multiValued=false, description="The username of a new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUser;
    @Option(name="--new-user-password", multiValued=false, description="The password of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserPassword;
    @Option(name="--new-user-role", multiValued=false, description="The role of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserRole = "admin";
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        FabricValidations.validateProfileName(this.profiles);
        CreateEnsembleOptions ensembleOptions = CreateEnsembleOptions.build().zookeeperPassword(this.zookeeperPassword).user(this.newUser, this.newUserPassword + "," + this.newUserRole);
        CreateSshContainerOptions options = ((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)((CreateSshContainerOptions)CreateContainerOptionsBuilder.ssh().name(this.name)).resolver(this.resolver)).ensembleServer(this.isEnsembleServer.booleanValue())).number(this.number)).host(this.host).username(this.user).password(this.password).privateKeyFile(this.privateKeyFile != null ? this.privateKeyFile : CreateSshContainerOptions.DEFAULT_PRIVATE_KEY_FILE).passPhrase(this.passPhrase).port(this.port).sshRetries(this.sshRetries).minimumPort(this.minimumPort)).maximumPort(this.maximumPort)).password(this.password).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).zookeeperPassword(this.isEnsembleServer != false && this.zookeeperPassword != null ? this.zookeeperPassword : this.fabricService.getZookeeperPassword())).jvmOpts(this.jvmOpts)).createEnsembleOptions(ensembleOptions);
        if (this.path != null && !this.path.isEmpty()) {
            options.setPath(this.path);
        }
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
        if (this.isEnsembleServer.booleanValue() && metadatas != null && metadatas.length > 0 && metadatas[0].isSuccess()) {
            ShellUtils.storeZookeeperPassword(this.session, metadatas[0].getCreateOptions().getZookeeperPassword());
        }
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }
}

