/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.ServiceHelper;

public class LogEndpoint
extends ProcessorEndpoint {
    private Processor logger;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, Processor logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.logger);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.logger);
    }

    public void setLogger(Processor logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new LogProducer(this, this.logger);
    }

    @Override
    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }
}

