/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.interceptor.DefaultTraceEventHandler;
import org.apache.camel.processor.interceptor.DefaultTraceFormatter;
import org.apache.camel.processor.interceptor.DefaultTraceInterceptorFactory;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptorFactory;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.util.CamelLogger;

public class Tracer
implements InterceptStrategy,
Service {
    private static final String JPA_TRACE_EVENT_MESSAGE = "org.apache.camel.processor.interceptor.jpa.JpaTraceEventMessage";
    private TraceFormatter formatter = new DefaultTraceFormatter();
    private boolean enabled = true;
    private String logName = Tracer.class.getName();
    private LoggingLevel logLevel = LoggingLevel.INFO;
    private Predicate traceFilter;
    private boolean traceInterceptors;
    private boolean traceExceptions = true;
    private boolean logStackTrace;
    private boolean traceOutExchanges;
    private String destinationUri;
    private Endpoint destination;
    private boolean useJpa;
    private CamelLogProcessor logger;
    private TraceInterceptorFactory traceInterceptorFactory = new DefaultTraceInterceptorFactory();
    private final List<TraceEventHandler> traceHandlers = new CopyOnWriteArrayList<TraceEventHandler>();
    private String jpaTraceEventMessageClassName = "org.apache.camel.processor.interceptor.jpa.JpaTraceEventMessage";
    private boolean jmxTraceNotifications;
    private int traceBodySize = 10000;

    public Tracer() {
        this.traceHandlers.add(new DefaultTraceEventHandler(this));
    }

    public static Tracer createTracer(CamelContext context) {
        Tracer tracer = new Tracer();
        TraceFormatter formatter = context.getRegistry().lookup("traceFormatter", TraceFormatter.class);
        if (formatter != null) {
            tracer.setFormatter(formatter);
        }
        return tracer;
    }

    public static Tracer getTracer(CamelContext context) {
        List<InterceptStrategy> list = context.getInterceptStrategies();
        for (InterceptStrategy interceptStrategy : list) {
            if (!(interceptStrategy instanceof Tracer)) continue;
            return (Tracer)interceptStrategy;
        }
        return null;
    }

    public synchronized CamelLogProcessor getLogger(ExchangeFormatter formatter) {
        if (this.logger == null) {
            this.logger = new CamelLogProcessor(new CamelLogger(this.getLogName(), this.getLogLevel()), formatter);
        }
        return this.logger;
    }

    @Override
    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        RouteDefinitionHelper.forceAssignIds(context, definition);
        return this.getTraceInterceptorFactory().createTraceInterceptor(definition, target, this.formatter, this);
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    public DefaultTraceFormatter getDefaultTraceFormatter() {
        if (this.formatter instanceof DefaultTraceFormatter) {
            return (DefaultTraceFormatter)this.formatter;
        }
        return null;
    }

    public void setFormatter(TraceFormatter formatter) {
        this.formatter = formatter;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTraceInterceptors() {
        return this.traceInterceptors;
    }

    public void setTraceInterceptors(boolean traceInterceptors) {
        this.traceInterceptors = traceInterceptors;
    }

    public Predicate getTraceFilter() {
        return this.traceFilter;
    }

    public void setTraceFilter(Predicate traceFilter) {
        this.traceFilter = traceFilter;
    }

    public LoggingLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LoggingLevel logLevel) {
        this.logLevel = logLevel;
        if (this.logger != null) {
            this.logger.getLogger().setLevel(logLevel);
        }
    }

    public boolean isTraceExceptions() {
        return this.traceExceptions;
    }

    public void setTraceExceptions(boolean traceExceptions) {
        this.traceExceptions = traceExceptions;
    }

    public boolean isLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
        if (this.logger != null) {
            this.logger.getLogger().setLogName(logName);
        }
    }

    public void setTraceOutExchanges(boolean traceOutExchanges) {
        this.traceOutExchanges = traceOutExchanges;
    }

    public boolean isTraceOutExchanges() {
        return this.traceOutExchanges;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public void setDestinationUri(String destinationUri) {
        this.destinationUri = destinationUri;
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public void setDestination(Endpoint destination) {
        this.destination = destination;
    }

    public boolean isUseJpa() {
        return this.useJpa;
    }

    public void setUseJpa(boolean useJpa) {
        this.useJpa = useJpa;
    }

    public TraceInterceptorFactory getTraceInterceptorFactory() {
        return this.traceInterceptorFactory;
    }

    public void setTraceInterceptorFactory(TraceInterceptorFactory traceInterceptorFactory) {
        this.traceInterceptorFactory = traceInterceptorFactory;
    }

    @Deprecated
    public TraceEventHandler getTraceHandler() {
        return this.traceHandlers.get(0);
    }

    public List<TraceEventHandler> getTraceHandlers() {
        return this.traceHandlers;
    }

    @Deprecated
    public void setTraceHandler(TraceEventHandler traceHandler) {
        this.traceHandlers.clear();
        this.traceHandlers.add(traceHandler);
    }

    public void addTraceHandler(TraceEventHandler traceHandler) {
        this.traceHandlers.add(traceHandler);
    }

    public void removeTraceHandler(TraceEventHandler traceHandler) {
        this.traceHandlers.add(traceHandler);
    }

    public String getJpaTraceEventMessageClassName() {
        return this.jpaTraceEventMessageClassName;
    }

    public void setJpaTraceEventMessageClassName(String jpaTraceEventMessageClassName) {
        this.jpaTraceEventMessageClassName = jpaTraceEventMessageClassName;
    }

    public boolean isJmxTraceNotifications() {
        return this.jmxTraceNotifications;
    }

    public void setJmxTraceNotifications(boolean jmxTraceNotifications) {
        this.jmxTraceNotifications = jmxTraceNotifications;
    }

    public int getTraceBodySize() {
        return this.traceBodySize;
    }

    public void setTraceBodySize(int traceBodySize) {
        this.traceBodySize = traceBodySize;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.traceHandlers.clear();
    }

    public String toString() {
        return "Tracer";
    }
}

