/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricRequirements;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.ProfileRequirements;
import org.fusesource.fabric.api.ProfileStatus;

public class FabricStatus {
    private final FabricService service;
    private FabricRequirements requirements;
    Map<String, ProfileStatus> profileStatusMap = new TreeMap<String, ProfileStatus>();

    public FabricStatus(FabricService service) {
        Container[] containers;
        this.service = service;
        this.requirements = service.getRequirements();
        List<ProfileRequirements> profileRequirements = this.requirements.getProfileRequirements();
        for (ProfileRequirements profileRequirement : profileRequirements) {
            String key = profileRequirement.getProfile();
            ProfileStatus status = this.profileStatusMap.get(key);
            if (status != null) continue;
            status = this.createStatus(key, profileRequirement);
            this.profileStatusMap.put(key, status);
        }
        for (Container container : containers = service.getContainers()) {
            Profile[] profiles;
            if (!container.isAliveAndOK()) continue;
            for (Profile profile : profiles = container.getProfiles()) {
                String key = profile.getId();
                ProfileStatus status = this.profileStatusMap.get(key);
                if (status == null) {
                    ProfileRequirements profileRequirement = new ProfileRequirements(key);
                    this.requirements.addOrUpdateProfileRequirements(profileRequirement);
                    status = this.createStatus(key, profileRequirement);
                    this.profileStatusMap.put(key, status);
                }
                status.incrementCount();
            }
        }
    }

    public Map<String, ProfileStatus> getProfileStatusMap() {
        return this.profileStatusMap;
    }

    public FabricRequirements getRequirements() {
        return this.requirements;
    }

    public FabricService getService() {
        return this.service;
    }

    protected ProfileStatus createStatus(String profileId, ProfileRequirements profileRequirement) {
        return new ProfileStatus(profileId, profileRequirement);
    }

    public String toString() {
        return "FabricStatus[requirements=" + this.requirements.getProfileRequirements() + ", profileStatusMap=" + this.profileStatusMap + ']';
    }
}

